/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.jrebel.remoting.builder.SynchronizationUtil;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;

public class SyncNowAction
implements IObjectActionDelegate {
    private static final ConsoleLog console = ConsoleLog.getInstance(SyncNowAction.class);
    private ISelection selection;

    public void run(IAction action) {
        console.debug("Manually triggered remote server synchronization.");
        List<IProject> projects = RebelXmlGenerator.getProjectsFromSelection(this.selection);
        if (!projects.isEmpty()) {
            action.setEnabled(true);
            SynchronizationUtil.synchronizeProjects(projects);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        IProject project = RebelXmlGenerator.getProjectFromSelection(selection);
        action.setEnabled(project != null && ProjectHelper.isJRebelRemotingProject(project));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

