/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.notifications.RedeployProjectNotification;

public class ToggleRemotingNatureAction
implements IObjectActionDelegate {
    private static final Log log = Log.getInstance(ToggleRemotingNatureAction.class);
    private ISelection selection;

    public void run(IAction action) {
        IProject project = this.getSelectedProject();
        if (project != null && ProjectHelper.isJRebelProject(project)) {
            action.setEnabled(true);
            this.toggleNature(project);
        } else {
            action.setEnabled(false);
        }
        this.updateDescription(action);
    }

    protected void toggleNature(IProject project) {
        boolean wasEnabled = ProjectHelper.isJRebelRemotingProject(project);
        log.info("Toggling project's JRebel remote server nature to {}, project: {}", (Object)(!wasEnabled ? 1 : 0), (Object)project);
        try {
            new RebelRemotingProvider().updateRemotingEnablement(project, !wasEnabled);
            if (!wasEnabled) {
                RedeployProjectNotification.show((boolean)true);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    private void updateDescription(IAction action) {
        IProject project = this.getSelectedProject();
        if (project != null) {
            boolean isRemotingProject = ProjectHelper.isJRebelRemotingProject(project);
            action.setText(isRemotingProject ? "Disable remote server support" : "Enable remote server support");
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.updateDescription(action);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.updateDescription(action);
    }

    protected IProject getSelectedProject() {
        return RebelXmlGenerator.getProjectFromSelection(this.selection);
    }
}

