/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.builder;

import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import com.zeroturnaround.jrebel.remoting.SyncOperation;
import com.zeroturnaround.jrebel.remoting.SyncOperationSettings;
import com.zeroturnaround.jrebel.remoting.fsobserver.manager.FileEventProcessor;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject;
import org.zeroturnaround.eclipse.preferences.PreferenceReader;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class EclipseFileEventProcessor
extends FileEventProcessor {
    private static final Log log = Log.getInstance(EclipseFileEventProcessor.class);
    private final IProject project;

    public EclipseFileEventProcessor(IProject project) {
        this.project = project;
    }

    protected BaseRemoteModule getRemotingProject() {
        return new RemotingProject(this.project);
    }

    protected String getProjectName() {
        return this.project.getName();
    }

    protected void runAsync(final String title, final Runnable runnable) {
        Job job = new Job(title){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    runnable.run();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    log.warn("Error with job: {}", (Object)title, (Object)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    protected File getProjectRoot() {
        return this.project.getLocation().toFile();
    }

    protected void scheduleSync(String title, final BaseRemoteModule remotingProject, final SyncOperationSettings syncSettings) {
        Job job = new Job(title){

            protected IStatus run(IProgressMonitor monitor) {
                SyncOperation.Listener listener = () -> this.done(Status.OK_STATUS);
                IdeRemoting.getInstance().getServers().scheduleSync(remotingProject, listener, syncSettings);
                return Job.ASYNC_FINISH;
            }
        };
        job.schedule();
    }

    protected void executeInUI(Runnable runnable) {
        EclipseUtil.runInUiThread(runnable);
    }

    protected boolean isSyncOnBuild() {
        return PreferenceReader.isSyncOnBuildGlobal();
    }
}

