/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.builder;

import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject;
import org.zeroturnaround.eclipse.jrebel.remoting.builder.EclipseFileEventProcessorManager;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class SynchronizationUtil {
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(SynchronizationUtil.class);

    public static void synchronizeAll() {
        List<IProject> remotingProjects = SynchronizationUtil.getRemotingProjectsList();
        if (SynchronizationUtil.hasProjectsWithRemotingEnabled()) {
            SynchronizationUtil.synchronizeProjects(remotingProjects);
        }
    }

    public static boolean hasProjectsWithRemotingEnabled() {
        return !SynchronizationUtil.getRemotingProjectsList().isEmpty();
    }

    public static List<IProject> getRemotingProjectsList() {
        IProject[] allProjects = EclipseUtil.getAllProjects();
        ArrayList<IProject> remotingProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectHelper.isJRebelRemotingProject(project)) {
                remotingProjects.add(project);
            }
            ++n2;
        }
        return remotingProjects;
    }

    public static List<BaseRemoteModule> getRemotingProjects() {
        List<IProject> projects = SynchronizationUtil.getRemotingProjectsList();
        ArrayList<BaseRemoteModule> result = new ArrayList<BaseRemoteModule>();
        for (IProject project : projects) {
            result.add(new RemotingProject(project));
        }
        return result;
    }

    public static void synchronizeProject(IProject project) {
        SynchronizationUtil.synchronizeProjects(Collections.singletonList(project));
    }

    public static void synchronizeProjects(final List<IProject> projects) {
        consoleLog.debug("Scheduling remote server synchronization for {} projects.", (Object)projects.size());
        Job job = new Job("Synchronizing " + projects.size() + " projects to remote servers."){

            protected IStatus run(IProgressMonitor monitor) {
                EclipseFileEventProcessorManager.getInstance().syncChanges(IdeRemoting.getInstance(), projects);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

