/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.console;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.remoting.console.RemotingConsoleFactory;
import org.zeroturnaround.eclipse.jrebel.remoting.console.RemotingConsoleImpl;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;

public class RemotingConsole
implements ConsoleLog.IdeConsoleLogger {
    private static boolean isDebug = RebelPlugin.getDefault().getPreferenceStore().getBoolean("jrebel.remoting.debugOutput");
    private static final RemotingConsole instance;

    static {
        RebelPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("jrebel.remoting.debugOutput".equals(event.getProperty())) {
                    isDebug = RebelPlugin.getDefault().getPreferenceStore().getBoolean("jrebel.remoting.debugOutput");
                }
            }
        });
        instance = new RemotingConsole();
    }

    private RemotingConsole() {
    }

    public static RemotingConsole getInstance() {
        return instance;
    }

    private static RemotingConsoleImpl getConsole() {
        return RemotingConsoleFactory.findOrCreateConsole();
    }

    public void info(String message) {
        RemotingConsole.getConsole().getOutStream().println(String.valueOf(RemotingConsole.getTimestamp()) + message);
    }

    public void debug(String message) {
        RemotingConsole.getConsole().getOutStream().println(String.valueOf(RemotingConsole.getTimestamp()) + message);
    }

    public void error(String message) {
        RemotingConsole.getConsole().getErrorStream().println(String.valueOf(RemotingConsole.getTimestamp()) + message);
    }

    public void warn(String msg, Throwable t) {
        this.error(msg, t);
    }

    public void warn(String msg) {
        this.error(msg);
    }

    public void error(String msg, Throwable e) {
        this.error(msg);
        RemotingConsole.getConsole().printStackTrace(e);
    }

    public boolean canLogDebug() {
        return isDebug;
    }

    private static String getTimestamp() {
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String ret = "[" + timestampFormat.format(new Date()) + "] ";
        return ret;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public void openConsole() {
        RemotingConsole.getConsole().activate();
    }
}

