/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.console;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.ui.RebelImage;

public final class RemotingConsoleImpl
extends MessageConsole
implements IPropertyChangeListener {
    private static final String CONSOLE_NAME = "JRebel Console";
    public static final String CONSOLE_TYPE = "JRebelRemoting";
    private final MessageConsoleStream outStream;
    private final MessageConsoleStream errorStream;
    private final MessageConsoleStream greenStream;
    private final PrintStream errorPrintStream;
    private final Color errorColor;
    private final Color greenColor;

    public RemotingConsoleImpl() {
        super(CONSOLE_NAME, RebelImage.JREBEL.getDescriptor(), true);
        this.setType(CONSOLE_TYPE);
        IPreferenceStore preferenceStore = RebelPlugin.getDefault().getPreferenceStore();
        this.outStream = this.newMessageStream();
        this.outStream.setActivateOnWrite(preferenceStore.getBoolean("jrebel.remoting.showOnOutput"));
        this.errorStream = this.newMessageStream();
        this.errorColor = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
        this.errorStream.setColor(this.errorColor);
        this.errorStream.setActivateOnWrite(preferenceStore.getBoolean("jrebel.remoting.showOnError"));
        this.errorPrintStream = new PrintStream((OutputStream)this.errorStream);
        this.greenStream = this.newMessageStream();
        this.greenColor = new Color((Device)Display.getDefault(), new RGB(0, 192, 0));
        this.greenStream.setColor(this.greenColor);
        this.greenStream.setActivateOnWrite(preferenceStore.getBoolean("jrebel.remoting.showOnOutput"));
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public MessageConsoleStream getOutStream() {
        return this.outStream;
    }

    public MessageConsoleStream getErrorStream() {
        return this.errorStream;
    }

    public MessageConsoleStream getGreenStream() {
        return this.greenStream;
    }

    public synchronized void printStackTrace(Throwable e) {
        e.printStackTrace(this.errorPrintStream);
        this.errorPrintStream.flush();
    }

    protected void dispose() {
        this.errorColor.dispose();
        this.greenColor.dispose();
        super.dispose();
        if (RebelPlugin.getDefault() != null) {
            RebelPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("jrebel.remoting.showOnOutput".equals(event.getProperty())) {
            this.outStream.setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
            this.greenStream.setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
        } else if ("jrebel.remoting.showOnError".equals(event.getProperty())) {
            this.errorStream.setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
        }
    }
}

