/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.actions.CloseConsoleAction;
import org.eclipse.ui.part.IPageBookViewPage;
import org.zeroturnaround.eclipse.jrebel.remoting.console.RemotingDebugOutputAction;
import org.zeroturnaround.eclipse.jrebel.remoting.console.ShowOnErrorAction;
import org.zeroturnaround.eclipse.jrebel.remoting.console.ShowOnOutputAction;
import org.zeroturnaround.eclipse.preferences.JRebelConfigCenterProxy;

public class RemotingConsolePageParticipant
implements IConsolePageParticipant {
    private RemotingDebugOutputAction debugOutputAction;
    private CloseConsoleAction closeAction;
    private ShowOnOutputAction showOnOutputAction;
    private ShowOnErrorAction showOnErrorAction;

    public void init(IPageBookViewPage page, IConsole console) {
        this.closeAction = new CloseConsoleAction(console);
        this.debugOutputAction = new RemotingDebugOutputAction();
        this.showOnOutputAction = new ShowOnOutputAction();
        this.showOnErrorAction = new ShowOnErrorAction();
        IActionBars actionBars = page.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
        this.configureMenu(actionBars.getMenuManager());
    }

    private void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", (IAction)this.closeAction);
        mgr.prependToGroup("outputGroup", (IAction)this.debugOutputAction);
        mgr.appendToGroup("outputGroup", (IAction)this.showOnOutputAction);
        mgr.appendToGroup("outputGroup", (IAction)this.showOnErrorAction);
    }

    private void configureMenu(IMenuManager mgr) {
        mgr.add((IAction)new Action("Open JRebel &Configuration"){

            public void run() {
                JRebelConfigCenterProxy.openConfigCenter();
            }
        });
    }

    public void dispose() {
        this.debugOutputAction.dispose();
        this.showOnOutputAction.dispose();
        this.showOnErrorAction.dispose();
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

