/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.services.IDisposable;
import org.zeroturnaround.eclipse.RebelPlugin;

public abstract class RemotingPreferenceToggleAction
extends Action
implements IPropertyChangeListener,
IDisposable {
    protected final String preference;

    public RemotingPreferenceToggleAction(String toolTip, String preference) {
        super(toolTip, 2);
        this.preference = preference;
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setChecked(this.getPreferenceStore().getBoolean(preference));
    }

    public final void setChecked(boolean checked) {
        super.setChecked(checked);
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void run() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        preferenceStore.setValue(this.preference, this.isChecked());
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.preference.equals(event.getProperty())) {
            this.setChecked((Boolean)event.getNewValue());
        }
    }

    protected final IPreferenceStore getPreferenceStore() {
        return RebelPlugin.getDefault().getPreferenceStore();
    }
}

