/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.extensions.sourceproviders;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ActivationState
extends AbstractSourceProvider {
    private static final Log log = Log.getInstance(ActivationState.class);
    public static final String STATE_ID = "org.zeroturnaround.eclipse.jrebel.remoting.license";
    private boolean enabled;

    public ActivationState() {
        this.updateLicenseStatus(Watcher.getInstance().getLastLicensingStatus());
    }

    public Map<String, Boolean> getCurrentState() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(STATE_ID, this.enabled);
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{STATE_ID};
    }

    private void setStatus(LicensingStatus status) {
        this.updateLicenseStatus(status);
        log.trace("Setting ActivationState ({}) status to {}", (Object)this, (Object)this.enabled);
        this.fireSourceChanged(0, STATE_ID, this.enabled);
    }

    private static ActivationState getInstance() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISourceProviderService sourceProviderService = (ISourceProviderService)window.getService(ISourceProviderService.class);
        ActivationState commandStateService = (ActivationState)sourceProviderService.getSourceProvider(STATE_ID);
        return commandStateService;
    }

    private void updateLicenseStatus(LicensingStatus status) {
        this.enabled = ActivationState.isValidLicense(status);
        log.info("updateLicenseStatus() - status=" + status + " valid=" + this.enabled);
    }

    private static boolean isValidLicense(LicensingStatus status) {
        return status == null ? false : status.isValid();
    }

    public static Watcher.Listener createLicenseChangeListener() {
        return new Watcher.Listener(){

            public void licenseStatusChanged(final LicensingStatus newStatus) {
                EclipseUtil.runInUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ActivationState instance = ActivationState.getInstance();
                        if (instance == null) {
                            log.warn("{} instance could not be found!", (Object)ActivationState.class.getSimpleName());
                        } else {
                            instance.setStatus(newStatus);
                        }
                    }
                });
            }
        };
    }

    public void dispose() {
    }
}

