/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.files;

import com.zeroturnaround.jrebel.remoting.FileNavigator;
import com.zeroturnaround.jrebel.remoting.configuration.Dir;
import com.zeroturnaround.jrebel.remoting.io.FileSystemBasedNavigator;
import com.zeroturnaround.jrebel.remoting.io.RebelFile;
import com.zeroturnaround.jrebel.remoting.io.Source;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.zeroturnaround.eclipse.jrebel.remoting.files.EclipseSource;
import org.zeroturnaround.jrebel.client.logger.Log;

public class EclipseFileNavigator
implements FileNavigator {
    private static final Log log = Log.getInstance(EclipseFileNavigator.class);
    private final IProject project;
    private final Dir parentDir;

    public EclipseFileNavigator(IProject project, Dir dir) {
        this.project = project;
        this.parentDir = dir;
        log.debug("Created EclipseFileSystemProvider for '" + this.parentDir.getAbsolutePath() + "'");
    }

    public List<RebelFile> getFiles() {
        if (!this.parentDir.isInsideProject()) {
            log.debug("Dir {} is outside project, use FileSystemProvider");
            FileSystemBasedNavigator fnav = new FileSystemBasedNavigator(this.parentDir);
            return fnav.getFiles();
        }
        IFolder folder = this.project.getFolder(Path.fromPortableString((String)this.parentDir.getProjectRelativePath()));
        log.info("Visiting folder " + folder.getFullPath());
        if (!folder.exists()) {
            throw new RuntimeException("Folder '" + folder.getFullPath().toString() + "' does not exist.");
        }
        FileVisitor visitor = new FileVisitor(folder);
        try {
            folder.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            throw new RuntimeException("Getting files for project '" + this.project.getName() + "' failed", e);
        }
        return visitor.files;
    }

    private class FileVisitor
    implements IResourceVisitor {
        private final List<RebelFile> files = new ArrayList<RebelFile>();
        IFolder folder;

        FileVisitor(IFolder folder) {
            this.folder = folder;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (1 == resource.getType()) {
                IFile file = (IFile)resource;
                String remotePath = EclipseFileNavigator.this.parentDir.calculateRemotePath(file.getFullPath().makeRelativeTo(this.folder.getFullPath()).toPortableString());
                if (EclipseFileNavigator.this.parentDir.matchesPattern(remotePath)) {
                    this.files.add(new RebelFile((Source)new EclipseSource(file), remotePath, EclipseFileNavigator.this.parentDir));
                }
            }
            return true;
        }
    }
}

