/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launch;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Display;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.launch.enable.AutoEnableLaunchConfigurationTask;
import org.zeroturnaround.eclipse.launch.ui.PreLaunchCheckDialog;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.LaunchConfigLaunchables;
import org.zeroturnaround.eclipse.launching.launchconfig.RebelLaunchConfigProviders;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.notifications.JRebelMissingInLaunchNotification;

public final class RebelArgsFixingLaunchListener
implements ILaunchListener,
ILaunchConfigurationListener {
    private static final ThreadLocal<Boolean> RECURSION = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final Log log = Log.getInstance(RebelArgsFixingLaunchListener.class);
    public static final String ATTR_LAZY_ENABLE_JREBEL = "org.zeroturnaround.eclipse.jrebel.LAZY_ENABLE_JREBEL";

    public void launchConfigurationChanged(ILaunchConfiguration config) {
        log.trace("launchConfigurationChanged. config: " + config + " hash=" + config.hashCode());
        if (!JRebel.isConfigured()) {
            return;
        }
        boolean recursiveCall = RECURSION.get();
        if (recursiveCall) {
            return;
        }
        try {
            try {
                RECURSION.set(Boolean.TRUE);
                IRebelLaunchConfig adaptor = RebelLaunchConfigProviders.createRebelLaunchConfig(config, config.getAttributes());
                if (adaptor != null) {
                    adaptor.updateIfNecessary(config);
                }
            }
            catch (CoreException e) {
                log.error((Throwable)e);
                if (!recursiveCall) {
                    RECURSION.remove();
                }
            }
        }
        finally {
            if (!recursiveCall) {
                RECURSION.remove();
            }
        }
    }

    public void launchAdded(ILaunch launch) {
        log.trace("launchAdded");
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null || RebelLaunchConfigProviders.shouldDisableJRebel(launch)) {
            return;
        }
        this.logLaunchConfigurationData(config);
        this.lazilyEnableJRebel(config);
        if (RebelPlugin.getDefault().getPreferenceStore().getBoolean("jrebelPreLaunchCheck")) {
            this.preLaunchJRebelEnablementCheck(config);
        }
        this.launchConfigurationChanged(config);
    }

    private void logLaunchConfigurationData(ILaunchConfiguration config) {
        log.trace("ILaunchConfiguration parameters for " + config);
        if (config == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            Map attributes = config.getAttributes();
            Set keys = attributes.keySet();
            for (Object key : keys) {
                sb.append("\nentry: " + key + "=" + attributes.get(key));
            }
        }
        catch (CoreException coreException) {}
        log.trace(sb.toString());
    }

    private void lazilyEnableJRebel(ILaunchConfiguration config) {
        try {
            IRebelLaunchConfig adaptor;
            if (config.getAttribute(ATTR_LAZY_ENABLE_JREBEL, false) && (adaptor = RebelLaunchConfigProviders.createRebelLaunchConfig(config)) != null) {
                LaunchConfigLaunchables.bind(config, adaptor).setJRebelEnabled(true);
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    private void preLaunchJRebelEnablementCheck(final ILaunchConfiguration config) {
        log.trace("preLaunchJRebelEnablementCheck 01");
        final IRebelLaunchConfig adaptor = RebelLaunchConfigProviders.createRebelLaunchConfig(config);
        if (adaptor != null) {
            log.trace("preLaunchJRebelEnablementCheck 02");
            boolean asked = false;
            if (adaptor.isAskToLaunchWithJRebelAllowed(config)) {
                try {
                    if (!adaptor.isJRebelEnabled(config)) {
                        String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                        log.trace("preLaunchJRebelEnablementCheck 03 " + projectName);
                        if (projectName != null) {
                            IProject project = EclipseUtil.getWorkspace().getRoot().getProject(projectName);
                            log.trace("preLaunchJRebelEnablementCheck 04 " + project);
                            if (ProjectHelper.isJRebelProject(project)) {
                                asked = true;
                                log.trace("preLaunchJRebelEnablementCheck 05");
                                final Display display = Display.getDefault();
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (PreLaunchCheckDialog.application(display.getActiveShell()).openPreLaunchCheck()) {
                                            try {
                                                LaunchConfigLaunchables.bind(config, adaptor).setJRebelEnabled(true);
                                            }
                                            catch (CoreException e) {
                                                log.error((Throwable)e);
                                            }
                                        }
                                    }
                                });
                                log.trace("preLaunchJRebelEnablementCheck 06");
                            }
                        } else {
                            asked = true;
                            final Display display = Display.getDefault();
                            log.trace("preLaunchJRebelEnablementCheck 07");
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (PreLaunchCheckDialog.server(display.getActiveShell()).openPreLaunchCheck()) {
                                        try {
                                            LaunchConfigLaunchables.bind(config, adaptor).setJRebelEnabled(true);
                                        }
                                        catch (CoreException e) {
                                            log.error((Throwable)e);
                                        }
                                    }
                                }
                            });
                            log.trace("preLaunchJRebelEnablementCheck 08");
                        }
                    }
                }
                catch (CoreException e) {
                    log.error((Throwable)e);
                }
            }
            boolean showNotification = !asked && adaptor.isJRebelApplicable(config) && !adaptor.isJRebelEnabled(config);
            log.trace("preLaunchJRebelEnablementCheck 10 " + showNotification);
            if (showNotification) {
                JRebelMissingInLaunchNotification.show();
            }
        }
    }

    public void launchChanged(ILaunch launch) {
        log.trace("launchChanged");
    }

    public void launchRemoved(ILaunch launch) {
        log.trace("launchRemoved");
    }

    public void launchConfigurationAdded(ILaunchConfiguration config) {
        AutoEnableLaunchConfigurationTask.enableJRebelForNewLaunchConfig(config);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration config) {
    }
}

