/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launch.enable;

import com.zeroturnaround.javarebel.conf.RebelConf;
import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.zeroturnaround.eclipse.api.JRebelIntegration;
import org.zeroturnaround.eclipse.launching.launchconfig.BoundRebelLaunchConfig;
import org.zeroturnaround.eclipse.util.EclipseMetricsUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.javarebel.preferences.Preferences;
import org.zeroturnaround.javarebel.preferences.PreferencesTransaction;
import org.zeroturnaround.javarebel.reporting.MessageType;
import org.zeroturnaround.javarebel.reporting.model.JRebelMetadata;
import org.zeroturnaround.javarebel.reporting.model.ReportMessage;
import org.zeroturnaround.javarebel.reporting.model.UserMetadata;
import org.zeroturnaround.javarebel.reporting.model.builder.MessageBuilder;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.metrics.IdeMetricsInstance;
import org.zeroturnaround.jrebel.client.preferences.PreferencesWrapper;
import org.zeroturnaround.jrebel.client.startup.SharedScheduler;

public class AutoEnableLaunchConfigurationTask {
    private static final Log log = Log.getInstance(AutoEnableLaunchConfigurationTask.class);
    private static final boolean ENABLED = RebelConf.getBooleanOrDefault((String)"rebel.ide.autoenable_run_config", (boolean)false);
    private static final String KEY_HAS_RAN_AUTOENABLE_LAUNCH_CONFIG = "com.zeroturnaround.jrebel.autoenable.launchconfig.HasEnabledStandalone";
    private static final String KEY_HAS_RAN_AUTOENABLE_WORKSPACE = "com.zeroturnaround.jrebel.autoenable.launchconfig.workspace.HasEnabledStandalone";

    private AutoEnableLaunchConfigurationTask() {
    }

    public static void start() {
        if (ENABLED) {
            SharedScheduler.getExecutor().execute(new AutoEnableLaunchConfigurationTask()::autoEnableJRebelForWorkspaceLaunchConfigs);
        } else {
            log.info("Feature disabled");
        }
    }

    private void autoEnableJRebelForWorkspaceLaunchConfigs() {
        try {
            try {
                List<BoundRebelLaunchConfig> rebelLaunchConfigs = JRebelIntegration.getBoundRebelLaunchConfigurations();
                if (this.shouldAutoEnable(rebelLaunchConfigs)) {
                    this.convertStandaloneLaunchConfigurations(rebelLaunchConfigs);
                }
            }
            catch (Exception e) {
                log.error("Failed to convert launch configurations", (Throwable)e);
                log.info("Autoenable for launch configurations finished");
                IdeInstance.getInstance().storage().setProperty(KEY_HAS_RAN_AUTOENABLE_WORKSPACE, true);
            }
        }
        finally {
            log.info("Autoenable for launch configurations finished");
            IdeInstance.getInstance().storage().setProperty(KEY_HAS_RAN_AUTOENABLE_WORKSPACE, true);
        }
    }

    private boolean shouldAutoEnable(List<BoundRebelLaunchConfig> rebelLaunchConfigs) {
        log.info("Current workspace: {}", (Object)EclipseUtil.getWorkspaceRoot());
        boolean hasRunAlready = IdeInstance.getInstance().storage().getProperty(KEY_HAS_RAN_AUTOENABLE_WORKSPACE, false);
        if (hasRunAlready) {
            log.debug("Has ran autoenable before");
            return false;
        }
        if (AutoEnableLaunchConfigurationTask.anyHaveJRebelEnabled(rebelLaunchConfigs)) {
            log.info("At least one launch configuration has JRebel enabled, skipping autoenable");
            return false;
        }
        return true;
    }

    private void convertStandaloneLaunchConfigurations(List<BoundRebelLaunchConfig> rebelLaunchConfigs) {
        int autoEnabledCount = 0;
        for (BoundRebelLaunchConfig config : rebelLaunchConfigs) {
            boolean enabled = AutoEnableLaunchConfigurationTask.enableJRebelIfSupported(config);
            if (!enabled) continue;
            ++autoEnabledCount;
        }
        if (autoEnabledCount > 0) {
            AutoEnableLaunchConfigurationTask.updateCountPrefs(autoEnabledCount);
        }
    }

    public static void enableJRebelForNewLaunchConfig(ILaunchConfiguration config) {
        boolean enabled;
        BoundRebelLaunchConfig rebelLaunchConfig;
        if (ENABLED && (rebelLaunchConfig = JRebelIntegration.tryToCreateBoundRebelLaunchConfig(config)) != null && (enabled = AutoEnableLaunchConfigurationTask.enableJRebelIfSupported(rebelLaunchConfig))) {
            AutoEnableLaunchConfigurationTask.updateCountPrefs(1);
        }
    }

    private static boolean enableJRebelIfSupported(BoundRebelLaunchConfig rebelLaunchConfig) {
        block5: {
            try {
                if (rebelLaunchConfig.isJRebelEnabled()) {
                    log.debug("Skipping autoenable. JRebel already enabled for launch configuration {}", rebelLaunchConfig.launchable);
                    break block5;
                }
                if (AutoEnableLaunchConfigurationTask.alreadyConverted(rebelLaunchConfig)) {
                    log.debug("Skipping autoenable. Have already autoenabled launch configuration {}", rebelLaunchConfig.launchable);
                    break block5;
                }
                if (!rebelLaunchConfig.isStandaloneType()) {
                    log.debug("Skipping autoenable. Non-standalone launch configuration {}", rebelLaunchConfig.launchable);
                    break block5;
                }
                log.info("Will enable JRebel for launch configuration {}", rebelLaunchConfig.launchable);
                AutoEnableLaunchConfigurationTask.enableJRebel(rebelLaunchConfig);
                return true;
            }
            catch (CoreException e) {
                log.error("Failed to autoenable launch configuration {}.", rebelLaunchConfig.launchable, (Object)e);
            }
        }
        return false;
    }

    private static void enableJRebel(BoundRebelLaunchConfig rebelLaunchConfig) throws CoreException {
        try {
            rebelLaunchConfig.setJRebelEnabled(true);
            AutoEnableLaunchConfigurationTask.sendEvent(rebelLaunchConfig);
        }
        finally {
            ILaunchConfigurationWorkingCopy workingCopy = rebelLaunchConfig.getWorkingCopy();
            workingCopy.setAttribute(KEY_HAS_RAN_AUTOENABLE_LAUNCH_CONFIG, true);
            rebelLaunchConfig.saveWorkingCopy(workingCopy);
        }
    }

    private static void sendEvent(BoundRebelLaunchConfig rebelLaunchConfig) {
        IdeMetricsInstance.getInstance().sendMessage(AutoEnableLaunchConfigurationTask.createMessageBuilder(rebelLaunchConfig));
    }

    private static MessageBuilder createMessageBuilder(final BoundRebelLaunchConfig rebelLaunchConfig) {
        return new MessageBuilder(){

            public ReportMessage build(Licensing.SDKLicenseInfo info, UserMetadata userMetadata, JRebelMetadata jrebelMetadata) {
                return new ReportMessage(MessageType.IdeAgentConfig, info).add("agent-enabled", (Object)true).add("project-type", (Object)"standalone").add("project-name", (Object)EclipseMetricsUtil.getHash(AutoEnableLaunchConfigurationTask.getProjectName(rebelLaunchConfig))).add("source", (Object)"auto-enable").add("workspace", (Object)EclipseMetricsUtil.getWorkspaceLocationHash());
            }
        };
    }

    private static String getProjectName(BoundRebelLaunchConfig rebelLaunchConfig) {
        try {
            return ((ILaunchConfiguration)rebelLaunchConfig.launchable).getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "unknown");
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    private static void updateCountPrefs(int autoEnabledCount) {
        Preferences prefs = PreferencesWrapper.getInstance().getPrefs();
        prefs.run(new PreferencesTransaction().putLong("ide.agent.auto-enable-count", prefs.getLong("ide.agent.auto-enable-count", 0L) + (long)autoEnabledCount).putLong("ide.agent.auto-enable-time", System.currentTimeMillis()));
    }

    private static boolean alreadyConverted(BoundRebelLaunchConfig rebelLaunchConfig) throws CoreException {
        return ((ILaunchConfiguration)rebelLaunchConfig.launchable).getAttribute(KEY_HAS_RAN_AUTOENABLE_LAUNCH_CONFIG, false);
    }

    private static boolean anyHaveJRebelEnabled(List<BoundRebelLaunchConfig> rebelLaunchConfigs) {
        for (BoundRebelLaunchConfig config : rebelLaunchConfigs) {
            if (!config.isJRebelEnabled()) continue;
            return true;
        }
        return false;
    }
}

