/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launch.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.ui.RebelImage;

public class PreLaunchCheckDialog
extends MessageDialog {
    private static final String[] DIALOG_BUTTON_LABELS = new String[]{"Launch with JRebel agent", "Not this time"};
    private boolean dontCheckAgain;

    private PreLaunchCheckDialog(Shell parentShell, String text) {
        super(parentShell, "Launch with JRebel?", RebelImage.JREBEL.getImage(), text, 3, DIALOG_BUTTON_LABELS, 0);
    }

    public static PreLaunchCheckDialog application(Shell parentShell) {
        return new PreLaunchCheckDialog(parentShell, "You are launching a JRebel-enabled application without the JRebel agent. JRebel will not work without it.");
    }

    public static PreLaunchCheckDialog server(Shell parentShell) {
        return new PreLaunchCheckDialog(parentShell, "You are launching a server with JRebel-enabled projects without the JRebel agent. JRebel will not work without it.");
    }

    public boolean openPreLaunchCheck() {
        int code = this.open();
        if (code != -1 && this.dontCheckAgain) {
            RebelPlugin.getDefault().getPreferenceStore().setValue("jrebelPreLaunchCheck", false);
        }
        return code == 0;
    }

    protected Control createCustomArea(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Don't perform this check again (you can restore it from Preferences)");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreLaunchCheckDialog.this.dontCheckAgain = button.getSelection();
            }
        });
        return button;
    }
}

