/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launching.googleappengine;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.zeroturnaround.common.args.Arg;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.ArgTriple;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.IArgStore;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.args.EclipseLaunchingArgs;
import org.zeroturnaround.eclipse.jrebel.args.LaunchConfigArgStore;
import org.zeroturnaround.eclipse.launching.launchconfig.RebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.support.LaunchUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class GAERebelLaunchConfig
extends RebelLaunchConfig {
    private static final Log log = Log.getInstance(GAERebelLaunchConfig.class);
    private static final ArgTriple<String> ARG_GAE_AGENT = Arg.triple((String)"-javaagent", (String)":", (String)"appengine-agent.jar").withValuesMatching(".*appengine\\-agent\\.jar");

    @Override
    public boolean isXRebelEnabled(ILaunchConfiguration launchable) {
        return false;
    }

    @Override
    public void setXRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
    }

    @Override
    public boolean isJRebelEnabled(ILaunchConfiguration config) {
        block3: {
            try {
                if (!config.getAttribute("org.zeroturnaround.eclipse.jrebel.LAZY_ENABLE_JREBEL", false)) break block3;
                return true;
            }
            catch (CoreException e) {
                log.error((Throwable)e);
                return false;
            }
        }
        return JRebel.getDefault().isEnabledIn((IArgStore)this.getArgStore(config, null));
    }

    @Override
    public void setJRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        if (enable) {
            workingCopy.setAttribute("org.zeroturnaround.eclipse.jrebel.LAZY_ENABLE_JREBEL", true);
        } else {
            workingCopy.setAttribute("org.zeroturnaround.eclipse.jrebel.LAZY_ENABLE_JREBEL", null);
        }
        ITransientArgStore<ILaunchConfigurationWorkingCopy> argStore = this.getArgStore((ILaunchConfiguration)workingCopy, workingCopy);
        ArgChanges changes = null;
        changes = enable ? EclipseLaunchingArgs.getJVMArgAdditions(this.getJVM((ILaunchConfiguration)workingCopy), null) : EclipseLaunchingArgs.getJVMArgRemovals();
        argStore.preview(changes);
        LaunchUtil.enableRebelClasspath(workingCopy, enable);
    }

    @Override
    public ITransientArgStore<ILaunchConfigurationWorkingCopy> getArgStore(ILaunchConfiguration config, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        return LaunchConfigArgStore.forAttrVMArguments(config, workingCopy, ArgFormatter.QUOTED, false);
    }

    @Override
    public void updateIfNecessary(ILaunchConfiguration config) throws CoreException {
        this.fixDuplicateGAEAgent(config);
        super.updateIfNecessary(config);
    }

    public void fixDuplicateGAEAgent(ILaunchConfiguration config) {
        try {
            ITransientArgStore<ILaunchConfigurationWorkingCopy> argStore = this.getArgStore(config, null);
            List gaeAgents = argStore.findAll(ARG_GAE_AGENT);
            if (gaeAgents.size() > 1) {
                IArgument exGaeAgent = (IArgument)gaeAgents.get(0);
                ArgChanges changes = new ArgChanges();
                changes.remove(ARG_GAE_AGENT);
                changes.add(exGaeAgent);
                ILaunchConfigurationWorkingCopy workingCopy = (ILaunchConfigurationWorkingCopy)argStore.preview(changes);
                if (workingCopy != null) {
                    workingCopy.doSave();
                }
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }
}

