/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launching.launchconfig;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.zeroturnaround.eclipse.launching.googleappengine.GAERebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfigProvider;
import org.zeroturnaround.eclipse.launching.launchconfig.RebelLaunchConfigProviders;
import org.zeroturnaround.eclipse.launching.launchconfig.VMArgsDynArgsRebelLaunchConfig;
import org.zeroturnaround.jrebel.client.logger.Log;

public class DefaultRebelLaunchConfigProvider
implements IRebelLaunchConfigProvider {
    private static final Log log = Log.getInstance(DefaultRebelLaunchConfigProvider.class);
    private static final String[] STD_ADAPTOR_TYPE_IDS = new String[]{"org.eclipse.jdt.launching.localJavaApplication", "org.eclipse.jdt.launching.javaApplet", "org.eclipse.jdt.junit.launchconfig", "org.maven.ide.eclipse.Maven2LaunchConfigurationType", "org.eclipse.m2e.Maven2LaunchConfigurationType", "scala.application", "scala.interpreter", "org.eclipse.pde.ui.RuntimeWorkbench", "org.eclipse.pde.ui.EquinoxLauncher", "org.eclipse.pde.ui.JunitLaunchConfig", "org.eclipse.rap.ui.launch.RAPLauncher", "org.eclipse.rap.ui.launch.RAPJUnitTestLauncher", "RunJettyRunWebApp", "org.springframework.ide.eclipse.boot.launch", "net.sourceforge.eclipsejetty.launchConfigurationType"};
    private static final String[] UNQUOTED_ADAPTOR_TYPE_IDS = new String[]{"org.grails.ide.eclipse.core.launchconfig"};
    private static final String[] GAE_ADAPTOR_TYPE_IDS = new String[]{"com.google.gdt.eclipse.suite.webapp", "com.gwtplugins.gdt.eclipse.suite.webapp"};
    private static final String[] ASK_TO_LAUNCH_WITH_JREBEL_TYPE_IDS = new String[]{"org.eclipse.jdt.launching.localJavaApplication", "org.eclipse.jdt.launching.javaApplet", "scala.application", "scala.interpreter", "com.gwtplugins.gdt.eclipse.suite.webapp", "com.google.gdt.eclipse.suite.webapp", "RunJettyRunWebApp", "org.springframework.ide.eclipse.boot.launch", "org.grails.ide.eclipse.core.launchconfig"};

    @Override
    public IRebelLaunchConfig createRebelLaunchConfig(ILaunchConfiguration config) {
        return this.createRebelLaunchConfig(config, null);
    }

    public IRebelLaunchConfig createRebelLaunchConfig(ILaunchConfiguration config, Map cookies) {
        if (RebelLaunchConfigProviders.typeIdMatches(config, STD_ADAPTOR_TYPE_IDS)) {
            return new VMArgsDynArgsRebelLaunchConfig();
        }
        if (RebelLaunchConfigProviders.typeIdMatches(config, UNQUOTED_ADAPTOR_TYPE_IDS)) {
            VMArgsDynArgsRebelLaunchConfig conf = new VMArgsDynArgsRebelLaunchConfig();
            conf.useQuotedPaths = false;
            return conf;
        }
        if (RebelLaunchConfigProviders.typeIdMatches(config, GAE_ADAPTOR_TYPE_IDS)) {
            return new GAERebelLaunchConfig();
        }
        this.logUnknownLaunchConfig(config);
        return null;
    }

    private void logUnknownLaunchConfig(ILaunchConfiguration config) {
        try {
            log.info("unknown type " + config.getType().getIdentifier());
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
        }
    }

    @Override
    public boolean shouldDisableJRebel(ILaunch launch) {
        return false;
    }

    public static boolean isAskToLaunchWithJRebelAllowed(ILaunchConfiguration config) {
        return RebelLaunchConfigProviders.typeIdMatches(config, ASK_TO_LAUNCH_WITH_JREBEL_TYPE_IDS);
    }
}

