/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launching.launchconfig;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.zeroturnaround.common.args.Arg;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.ArgOpaque;
import org.zeroturnaround.common.args.ArgTriple;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.eclipse.jrebel.args.DynamicRebelArgs;
import org.zeroturnaround.eclipse.launching.launchconfig.RebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.support.LaunchUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class DynamicArgsRebelLaunchConfig
extends RebelLaunchConfig {
    private static final Log log = Log.getInstance(DynamicArgsRebelLaunchConfig.class);
    public boolean useQuotedPaths = true;
    private boolean usePaddedPaths = false;

    @Override
    public abstract ITransientArgStore<ILaunchConfigurationWorkingCopy> getArgStore(ILaunchConfiguration var1, ILaunchConfigurationWorkingCopy var2) throws CoreException;

    @Override
    public boolean isJRebelEnabled(ILaunchConfiguration config) {
        try {
            return this.getArgStore(config, null).contains((IArgument)DynamicRebelArgs.ANY_REBEL_ARGS);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void setJRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        ITransientArgStore<ILaunchConfigurationWorkingCopy> argStore = this.getArgStore((ILaunchConfiguration)workingCopy, workingCopy);
        ArgTriple resinSysLoader = Arg.property((String)"java.system.class.loader", (String)"com.caucho.loader.SystemClassLoader").withValuesMatching("com.caucho.loader.SystemClassLoader");
        log.info("setJRebelEnabled: {}", (Object)enable);
        ArgChanges changes = new ArgChanges();
        if (enable) {
            changes.add((IArgument)this.getJRebelDynamicVMArgs((ILaunchConfiguration)workingCopy));
            if (argStore.contains((IArgument)resinSysLoader)) {
                log.info("Removing com.caucho.loader.SystemClassLoader");
                changes.remove((IArgument)resinSysLoader);
                workingCopy.setAttribute("jrebel.removedResinClassloader", true);
            }
        } else {
            changes.remove((IArgument)DynamicRebelArgs.ANY_REBEL_ARGS);
            if (workingCopy.getAttribute("jrebel.removedResinClassloader", false)) {
                log.info("Putting back com.caucho.loader.SystemClassLoader");
                changes.add((IArgument)resinSysLoader);
                workingCopy.setAttribute("jrebel.removedResinClassloader", false);
            }
        }
        argStore.preview(changes);
        LaunchUtil.enableRebelClasspath(workingCopy, enable);
        log.info("setJRebelEnabled - done");
    }

    @Override
    public boolean isXRebelEnabled(ILaunchConfiguration config) {
        try {
            return this.getArgStore(config, null).contains((IArgument)DynamicRebelArgs.ANY_XREBEL_ARGS);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void setXRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        ITransientArgStore<ILaunchConfigurationWorkingCopy> argStore = this.getArgStore((ILaunchConfiguration)workingCopy, workingCopy);
        log.info("setXRebelEnabled: {}", (Object)enable);
        ArgChanges changes = new ArgChanges();
        if (enable) {
            changes.add((IArgument)this.getXRebelDynamicVMArgs((ILaunchConfiguration)workingCopy));
        } else {
            changes.remove((IArgument)DynamicRebelArgs.ANY_XREBEL_ARGS);
        }
        argStore.preview(changes);
        log.info("setXRebelEnabled - done");
    }

    public ArgOpaque getJRebelDynamicVMArgs(ILaunchConfiguration config) throws CoreException {
        log.trace("getJRebelDynamicVMArgs");
        return DynamicRebelArgs.dynamicJRebelArgs(this.getJVM(config), config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null), !this.useQuotedPaths, this.usePaddedPaths);
    }

    public ArgOpaque getXRebelDynamicVMArgs(ILaunchConfiguration config) throws CoreException {
        return DynamicRebelArgs.dynamicXRebelArgs(this.getJVM(config), null, !this.useQuotedPaths, this.usePaddedPaths);
    }

    @Override
    public void updateIfNecessary(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy;
        ArgChanges changes;
        if (config.isWorkingCopy()) {
            return;
        }
        ITransientArgStore<ILaunchConfigurationWorkingCopy> argStore = this.getArgStore(config, null);
        if (argStore.contains((IArgument)DynamicRebelArgs.ANY_REBEL_ARGS)) {
            if (argStore.contains((IArgument)DynamicRebelArgs.UNQUOTED_REBEL_ARGS)) {
                this.useQuotedPaths = false;
            }
            if (argStore.contains((IArgument)DynamicRebelArgs.PADDED_REBEL_ARGS)) {
                this.usePaddedPaths = true;
            }
            changes = new ArgChanges();
            changes.remove((IArgument)DynamicRebelArgs.ANY_REBEL_ARGS);
            changes.add((IArgument)this.getJRebelDynamicVMArgs(config));
            workingCopy = (ILaunchConfigurationWorkingCopy)argStore.preview(changes);
            if (workingCopy != null) {
                workingCopy.doSave();
            }
        }
        if (argStore.contains((IArgument)DynamicRebelArgs.ANY_XREBEL_ARGS)) {
            if (argStore.contains((IArgument)DynamicRebelArgs.UNQUOTED_XREBEL_ARGS)) {
                this.useQuotedPaths = false;
            }
            if (argStore.contains((IArgument)DynamicRebelArgs.PADDED_XREBEL_ARGS)) {
                this.usePaddedPaths = true;
            }
            changes = new ArgChanges();
            changes.remove((IArgument)DynamicRebelArgs.ANY_XREBEL_ARGS);
            changes.add((IArgument)this.getXRebelDynamicVMArgs(config));
            workingCopy = (ILaunchConfigurationWorkingCopy)argStore.preview(changes);
            if (workingCopy != null) {
                workingCopy.doSave();
            }
        }
    }

    protected ArgFormatter getArgFormatter() {
        return this.useQuotedPaths ? ArgFormatter.QUOTED : ArgFormatter.ID;
    }
}

