/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launching.launchconfig;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfigProvider;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfigProviderCookies;

public class RebelLaunchConfigProviders {
    public static final String EXT_ID = "org.zeroturnaround.eclipse.rebelLaunchConfigurationAdaptor";

    public static List<IRebelLaunchConfigProvider> getProviders() {
        return Hooks.getHookList(IRebelLaunchConfigProvider.class, EXT_ID);
    }

    public static IRebelLaunchConfig createRebelLaunchConfig(ILaunchConfiguration config) {
        return RebelLaunchConfigProviders.createRebelLaunchConfig(config, null);
    }

    public static IRebelLaunchConfig createRebelLaunchConfig(ILaunchConfiguration config, Map cookies) {
        List<IRebelLaunchConfigProvider> providers = RebelLaunchConfigProviders.getProviders();
        for (IRebelLaunchConfigProvider provider : providers) {
            IRebelLaunchConfig adaptor = null;
            adaptor = provider instanceof IRebelLaunchConfigProviderCookies ? ((IRebelLaunchConfigProviderCookies)provider).createRebelLaunchConfig(config, cookies) : provider.createRebelLaunchConfig(config);
            if (adaptor == null) continue;
            return adaptor;
        }
        return null;
    }

    public static boolean shouldDisableJRebel(ILaunch launch) {
        List<IRebelLaunchConfigProvider> providers = RebelLaunchConfigProviders.getProviders();
        for (IRebelLaunchConfigProvider provider : providers) {
            if (!provider.shouldDisableJRebel(launch)) continue;
            return true;
        }
        return false;
    }

    public static boolean typeIdMatches(ILaunchConfiguration config, String[] typeIdPatterns) {
        String[] stringArray = typeIdPatterns;
        int n = typeIdPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String configTypeId = stringArray[n2];
            if (RebelLaunchConfigProviders.typeIdMatches(config, configTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean typeIdMatches(ILaunchConfiguration config, String typeIdPattern) {
        ILaunchConfigurationType type;
        block5: {
            try {
                type = config.getType();
                if (!typeIdPattern.endsWith("*")) break block5;
                String partialId = typeIdPattern.substring(0, typeIdPattern.length() - 1);
                if (type.getIdentifier().startsWith(partialId)) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (type.getIdentifier().equals(typeIdPattern)) {
            return true;
        }
        return false;
    }
}

