/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launching.support;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JVMHelper {
    private static final Log log = Log.getInstance(JVMHelper.class);
    public static final String STANDARD_VM_PREFIX = String.valueOf(JavaRuntime.JRE_CONTAINER) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/";
    private static Map<JavaVM, WeakReference<IVMInstall>> jvmCache = new WeakHashMap<JavaVM, WeakReference<IVMInstall>>();

    public static String getJREContainerPathAbbreviated(String jrePath, IVMInstall vmInstall) throws CoreException {
        if ((jrePath == null || jrePath.length() == 0) && vmInstall != null) {
            jrePath = JVMHelper.getJREContainerPath(vmInstall);
        }
        if (jrePath != null && jrePath.startsWith(STANDARD_VM_PREFIX) && jrePath.length() > STANDARD_VM_PREFIX.length()) {
            jrePath = jrePath.substring(STANDARD_VM_PREFIX.length());
        }
        return jrePath;
    }

    private static String getJREContainerPath(IVMInstall vm) {
        return String.valueOf(JavaRuntime.JRE_CONTAINER) + "/" + vm.getVMInstallType().getId() + "/" + vm.getName();
    }

    public static boolean isDefault(IVMInstall vm) {
        return JavaRuntime.getDefaultVMInstall().equals(vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaVM getJavaVM(IVMInstall vmInstall) throws CoreException {
        log.info("getJavaVM(IVMInstall vmInstall) vmInstall=[" + (vmInstall == null ? "null" : vmInstall.getInstallLocation()) + "]");
        vmInstall = vmInstall != null ? vmInstall : JavaRuntime.getDefaultVMInstall();
        JavaVM jvm = JavaVM.getJavaJVM((File)vmInstall.getInstallLocation());
        Map<JavaVM, WeakReference<IVMInstall>> map = jvmCache;
        synchronized (map) {
            jvmCache.put(jvm, new WeakReference<IVMInstall>(vmInstall));
        }
        return jvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMInstall getVMInstall(JavaVM jvm) {
        Map<JavaVM, WeakReference<IVMInstall>> map = jvmCache;
        synchronized (map) {
            WeakReference<IVMInstall> ref = jvmCache.get(jvm);
            return ref != null ? (IVMInstall)ref.get() : null;
        }
    }
}

