/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.launching.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.zeroturnaround.eclipse.api.JRebelIntegration;
import org.zeroturnaround.eclipse.jdt.RebelClasspathContainer;
import org.zeroturnaround.eclipse.launching.launchconfig.BoundRebelLaunchConfig;
import org.zeroturnaround.eclipse.plugins.RebelPluginProxy;
import org.zeroturnaround.jrebel.client.logger.Log;

public class LaunchUtil {
    private static final Log log = Log.getInstance(LaunchUtil.class);

    protected LaunchUtil() {
    }

    public static void enableRebelClasspath(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        IRuntimeClasspathEntry[] classpath = null;
        try {
            classpath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
        }
        catch (CoreException coreException) {
            return;
        }
        ArrayList<String> mementos = new ArrayList<String>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IRuntimeClasspathEntry entry = classpath[i];
            if (!RebelClasspathContainer.containerId().equals((Object)entry.getPath())) {
                mementos.add(entry.getMemento());
            }
            ++i;
        }
        if (enable && RebelPluginProxy.hasPlugins()) {
            IRuntimeClasspathEntry entry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)RebelClasspathContainer.containerId(), (int)3);
            mementos.add(entry.getMemento());
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
        classpath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
        if (LaunchUtil.isDefaultClasspath(classpath, (ILaunchConfiguration)workingCopy)) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        }
    }

    public static void setJRebelDisabledForStandaloneLaunchConfigurations() {
        try {
            log.info("Starting to remove JRebel args from standalone launch configurations.");
            List<BoundRebelLaunchConfig> configs = JRebelIntegration.getBoundRebelLaunchConfigurations();
            for (BoundRebelLaunchConfig config : configs) {
                if (!config.isStandaloneType() || !config.isJRebelEnabled()) continue;
                config.setJRebelEnabled(false);
                log.info("Removed JRebel args from {}", config.launchable);
            }
            log.info("Completed removing JRebel args from standalone launch configurations.");
        }
        catch (Exception ex) {
            log.error("Unable to remove JRebel args from standalone launch configurations", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isDefaultClasspath(IRuntimeClasspathEntry[] classpath, ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
            if (classpath.length != entries.length) return false;
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return true;
                }
                IRuntimeClasspathEntry entry = entries[i];
                if (!entry.equals(classpath[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

