/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.ProjectNatureUtil;
import org.zeroturnaround.eclipse.nature.property.BooleanProjectProperty;
import org.zeroturnaround.eclipse.nature.property.StringProjectProperty;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JRebelProject
implements IProjectNature {
    private static final Log log = Log.getInstance(JRebelProject.class);
    public static final String QN_QUALIFIER = "org.zeroturnaround.eclipse.jrebel";
    public static final String NATURE_ID = "org.zeroturnaround.eclipse.jrebelNature";
    private IProject project;

    public JRebelProject() {
    }

    public JRebelProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.zeroturnaround.eclipse.rebelXmlBuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.zeroturnaround.eclipse.rebelXmlBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.zeroturnaround.eclipse.rebelXmlBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public boolean isJRebelDisabled() {
        try {
            return (Boolean)this.disabled().get(this.project);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return false;
        }
    }

    public void setJRebelDisabled(boolean value) {
        this.disabled().set(this.project, value);
    }

    private BooleanProjectProperty disabled() {
        return new BooleanProjectProperty(new QualifiedName(QN_QUALIFIER, "jrebelDisabled"));
    }

    public BooleanProjectProperty useRelativePaths() {
        return new BooleanProjectProperty(new QualifiedName(QN_QUALIFIER, "genRebelXmlUseRelativePaths"));
    }

    public BooleanProjectProperty hasCustomXmlDirectory() {
        return new BooleanProjectProperty(new QualifiedName(QN_QUALIFIER, "hasCustomXmlDirectory"), Boolean.FALSE);
    }

    public StringProjectProperty customXmlDirectoryPath() {
        return new StringProjectProperty(new QualifiedName(QN_QUALIFIER, "customXmlDirectoryPath"), null);
    }

    @NotNull
    IContainer getRebelXmlTargetFolder() {
        IContainer customFolder = this.getProjectCustomXmlFolder();
        if (customFolder != null) {
            return customFolder;
        }
        try {
            return RebelXmlGenerator.forProject(this.project).findBestSourceFolderForRebelXml();
        }
        catch (CoreException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public IContainer getProjectCustomXmlFolder() {
        if (!((Boolean)this.hasCustomXmlDirectory().get(this.project)).booleanValue()) {
            return null;
        }
        String directoryPath = StringUtils.trimToEmpty((String)((String)this.customXmlDirectoryPath().get(this.project)));
        if (directoryPath.isEmpty()) {
            return this.getProject();
        }
        return this.getProject().getFolder(directoryPath);
    }

    public RebelXmlGenerator.Input getXmlGeneratorInput() {
        IContainer targetFolder = this.getRebelXmlTargetFolder();
        boolean useRelativePaths = (Boolean)this.useRelativePaths().get(this.project);
        return new RebelXmlGenerator.Input(targetFolder, useRelativePaths);
    }

    public static void updateJRebelEnablement(IProject project, boolean enabled, IProgressMonitor monitor) {
        log.info("updateJRebelEnablement for '{}', enabled={}", (Object)project, (Object)enabled);
        JRebelProject rebelProject = new JRebelProject(project);
        rebelProject.setJRebelDisabled(!enabled);
        if (enabled) {
            ProjectNatureUtil.addNatureTo(project, monitor, NATURE_ID);
            JRebelProject.buildProject(project, monitor);
        } else {
            rebelProject.deleteRebelXmlWithBackup();
            ProjectNatureUtil.removeNatureFrom(project, monitor, NATURE_ID);
            new RebelRemotingProvider().updateRemotingEnablement(project, false, monitor);
        }
    }

    private static void buildProject(final IProject project, IProgressMonitor monitor) {
        Job job = new Job(String.format("Generating JRebel configuration files for %s.", project.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(10, "org.zeroturnaround.eclipse.rebelXmlBuilder", null, monitor);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    log.warn("Build failed for project: {}", (Object)project, (Object)e);
                    return Status.OK_STATUS;
                }
            }
        };
        job.setProgressGroup(monitor, 1);
        job.setRule(JRebelProject.buildRule(project));
        job.schedule();
    }

    private static ISchedulingRule buildRule(IProject project) {
        return project.getWorkspace().getRuleFactory().buildRule();
    }

    public void deleteRebelXmlWithBackup() {
        ProjectHelper.deleteWithBackup(this.project, ProjectHelper.getRebelXml(this.project));
    }
}

