/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.zeroturnaround.jrebel.client.logger.Log;

public class MyResourceVisitor
implements IResourceVisitor {
    private static final Log log = Log.getInstance(MyResourceVisitor.class);
    private final String filename;
    private final String foldername;
    private List<String> excludes = null;
    private IResource ret;
    private boolean hasLoggedResult;

    public MyResourceVisitor(String filename, String foldername) {
        this(filename, foldername, null);
    }

    public MyResourceVisitor(String filename, String foldername, List<String> excludes) {
        this.filename = filename;
        this.foldername = foldername;
        this.excludes = excludes;
        this.hasLoggedResult = false;
        log.debug("Created visitor for " + this.getMode());
    }

    public boolean visit(IResource resource) throws CoreException {
        IFolder folder;
        if (this.excludes != null && resource != null && this.excludes.contains(resource.getName())) {
            log.debug("skipping " + resource.getName());
            return false;
        }
        if (this.filename != null && resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (this.filename.equals(file.getName())) {
                this.ret = file;
            }
        } else if (this.foldername != null && resource instanceof IFolder && (folder = (IFolder)resource).getFullPath().toString().endsWith(this.foldername)) {
            this.ret = folder;
        }
        return this.ret == null;
    }

    public IFile getFoundFile() {
        if (this.ret != null && !this.hasLoggedResult) {
            log.debug("getFoundFile() " + this.ret);
            this.hasLoggedResult = true;
        }
        return (IFile)this.ret;
    }

    public IFolder getFoundFolder() {
        if (this.ret != null && !this.hasLoggedResult) {
            log.debug("getFoundFolder() " + this.ret);
            this.hasLoggedResult = true;
        }
        return (IFolder)this.ret;
    }

    private String getMode() {
        if (this.filename != null) {
            return "filename: " + this.filename;
        }
        if (this.foldername != null) {
            return "foldername: " + this.foldername;
        }
        return "unknown";
    }
}

