/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import com.zeroturnaround.jrebel.ide.common.IdeModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.nature.IRebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.MyResourceVisitor;
import org.zeroturnaround.eclipse.nature.ProjectNatureUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.utils.RebelConfBackupUtil;

public class ProjectHelper {
    private static final Log log = Log.getInstance(ProjectHelper.class);
    public static final String MAVEN_NATURE_ID = "org.eclipse.m2e.core.maven2Nature";
    private static final String GRADLE_NATURE_ID = "org.eclipse.buildship.core.gradleprojectnature";
    public static final String REBEL_XML = "rebel.xml";
    public static final String REBEL_REMOTE_XML = "rebel-remote.xml";
    public static final List<String> DEFAULT_OUT_FOLDERS = Arrays.asList("target", "bin", "build");

    public static JRebelProject getJRebelProject(IProject project) throws CoreException {
        return project.isOpen() ? (JRebelProject)project.getNature("org.zeroturnaround.eclipse.jrebelNature") : null;
    }

    public static boolean isJavaProject(IProject project) {
        return ProjectHelper.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static boolean isMavenProject(IProject project) {
        return ProjectHelper.hasNature(project, MAVEN_NATURE_ID);
    }

    public static boolean isGradleProject(IProject project) {
        return ProjectHelper.hasNature(project, GRADLE_NATURE_ID);
    }

    public static boolean isEarProject(IProject project) {
        if (ProjectHelper.isJavaProject(project)) {
            return false;
        }
        return ProjectHelper.hasNature(project, "org.eclipse.wst.common.project.facet.core.nature") || ProjectHelper.hasNature(project, "org.eclipse.wst.common.modulecore.ModuleCoreNature");
    }

    public static boolean isStandaloneProject(IProject project) {
        if (!ProjectHelper.hasNature(project, "org.eclipse.jdt.core.javanature")) {
            log.debug("{} Does not have Java nature", (Object)project);
            return false;
        }
        if (ProjectHelper.hasNature(project, "org.eclipse.wst.common.project.facet.core.nature")) {
            log.debug("{} Has o.e.w.c.p.f.c.nature", (Object)project);
            return false;
        }
        if (ProjectHelper.hasNature(project, "org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
            log.debug("{} Has o.e.w.c.m.ModuleCoreNature", (Object)project);
            return false;
        }
        return true;
    }

    public static boolean isJRebelProject(IProject project) {
        JRebelProject rebelProject;
        block8: {
            block7: {
                if (project == null || !project.isOpen()) {
                    return false;
                }
                rebelProject = new JRebelProject(project);
                if (!rebelProject.isJRebelDisabled()) break block7;
                return false;
            }
            if (!ProjectHelper.hasJRebelNature(project)) break block8;
            return true;
        }
        try {
            if (ProjectHelper.isAutoAddJRebelNature() && ProjectHelper.hasNature(project, "org.eclipse.jdt.core.javanature")) {
                boolean hasRebelXml = ProjectHelper.hasRebelXml(project);
                if (hasRebelXml) {
                    ProjectNatureUtil.addNatureTo(project, null, "org.zeroturnaround.eclipse.jrebelNature");
                }
                rebelProject = ProjectHelper.getJRebelProject(project);
                return hasRebelXml && rebelProject != null;
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
        return false;
    }

    private static boolean isAutoAddJRebelNature() {
        return RebelPlugin.getDefault().getPreferenceStore().getBoolean("jrebelAutoNature");
    }

    public static boolean hasJRebelNature(IProject project) {
        return ProjectHelper.hasNature(project, "org.zeroturnaround.eclipse.jrebelNature");
    }

    public static boolean hasNature(@Nullable IProject project, String nature) {
        if (project == null || !project.isOpen()) {
            return false;
        }
        try {
            return project.hasNature(nature);
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
            return false;
        }
    }

    public static boolean isJRebelRemotingProject(IProject project) {
        IRebelRemotingProvider remotingProvider = Hooks.getHookOpt(IRebelRemotingProvider.class, "org.zeroturnaround.eclipse.remotingProvider");
        return remotingProvider != null ? remotingProvider.isRemotingProject(project) : false;
    }

    private static boolean hasRebelXml(IProject project) {
        return ProjectHelper.getRebelXml(project) != null;
    }

    public static boolean hasRebelRemoteXml(IProject project) {
        return ProjectHelper.getRebelRemoteXml(project) != null;
    }

    public static IFile getRebelXml(IProject project) {
        return ProjectHelper.getProjectConfFile(project, REBEL_XML, false);
    }

    public static IFile getRebelRemoteXml(IProject project) {
        return ProjectHelper.getProjectConfFile(project, REBEL_REMOTE_XML, true);
    }

    private static IFile getProjectConfFile(IProject project, String fileName, boolean sourceOnly) {
        IFile path = ProjectHelper.getProjectCustomXmlFile(project, fileName);
        if (path != null) {
            return path;
        }
        return ProjectHelper.findClasspathFile(project, fileName, sourceOnly);
    }

    private static IFile getProjectCustomXmlFile(IProject project, String fileName) {
        IContainer location = new JRebelProject(project).getProjectCustomXmlFolder();
        if (location == null) {
            return null;
        }
        IFile rebelFile = location.getFile(Path.fromPortableString((String)fileName));
        return rebelFile.exists() ? rebelFile : null;
    }

    private static IFile findClasspathFile(IProject project, String filename, boolean sourceOnly) {
        if (!project.isOpen()) {
            return null;
        }
        try {
            log.trace("findClasspathFile '{}', {}, {}", new Object[]{project.getName(), filename, sourceOnly});
            IJavaProject javaProject = EclipseUtil.getJavaProject(project);
            if (javaProject != null) {
                IFolder folder;
                IFile file;
                IFile file2;
                IFolder folder2;
                IFile file3;
                IClasspathEntry cp;
                IClasspathEntry[] classpath;
                IWorkspaceRoot root = project.getWorkspace().getRoot();
                IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
                int n = classpath.length;
                int n2 = 0;
                while (n2 < n) {
                    cp = iClasspathEntryArray[n2];
                    if (cp.getEntryKind() == 3 && cp.getPath() != null) {
                        if (cp.getPath().equals((Object)project.getFullPath())) {
                            file3 = project.getFile(filename);
                            if (file3.exists()) {
                                return file3;
                            }
                        } else {
                            folder2 = root.getFolder(cp.getPath());
                            file2 = folder2.getFile(filename);
                            if (file2.getLocation().toFile().exists()) {
                                return file2;
                            }
                        }
                    }
                    ++n2;
                }
                if (!sourceOnly) {
                    iClasspathEntryArray = classpath;
                    n = classpath.length;
                    n2 = 0;
                    while (n2 < n) {
                        cp = iClasspathEntryArray[n2];
                        if (cp.getEntryKind() == 3 && cp.getOutputLocation() != null) {
                            if (cp.getOutputLocation().equals((Object)project.getFullPath())) {
                                file3 = project.getFile(filename);
                                if (file3.exists()) {
                                    return file3;
                                }
                            } else {
                                folder2 = root.getFolder(cp.getOutputLocation());
                                file2 = folder2.getFile(filename);
                                if (file2.exists()) {
                                    return file2;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (javaProject.getOutputLocation().equals((Object)project.getFullPath())) {
                    IFile file4 = project.getFile(filename);
                    if (file4.exists()) {
                        return file4;
                    }
                } else if (!sourceOnly && (file = (folder = root.getFolder(javaProject.getOutputLocation())).getFile(filename)).exists()) {
                    return file;
                }
            } else {
                MyResourceVisitor visitor = new MyResourceVisitor(filename, null, DEFAULT_OUT_FOLDERS);
                project.accept((IResourceVisitor)visitor);
                if (visitor.getFoundFile() != null) {
                    return visitor.getFoundFile();
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return null;
    }

    public static Set<String> findClasspathFileFolders(IProject project, String filename, boolean sourceOnly) {
        if (!project.isOpen()) {
            return null;
        }
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        try {
            IJavaProject javaProject = EclipseUtil.getJavaProject(project);
            if (javaProject != null) {
                IFile file;
                IFolder folder;
                IFile file2;
                IClasspathEntry cp;
                IClasspathEntry[] classpath;
                IWorkspaceRoot root = project.getWorkspace().getRoot();
                IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
                int n = classpath.length;
                int n2 = 0;
                while (n2 < n) {
                    cp = iClasspathEntryArray[n2];
                    if (cp.getEntryKind() == 3 && cp.getPath() != null) {
                        if (cp.getPath().equals((Object)project.getFullPath())) {
                            file2 = project.getFile(filename);
                            ret.add(cp.getPath().toString());
                            if (file2.exists()) {
                                return ret;
                            }
                        } else {
                            folder = root.getFolder(cp.getPath());
                            file = folder.getFile(filename);
                            ret.add(folder.toString());
                            if (file.exists()) {
                                return ret;
                            }
                        }
                    }
                    ++n2;
                }
                if (!sourceOnly) {
                    iClasspathEntryArray = classpath;
                    n = classpath.length;
                    n2 = 0;
                    while (n2 < n) {
                        cp = iClasspathEntryArray[n2];
                        if (cp.getEntryKind() == 3 && cp.getOutputLocation() != null) {
                            if (cp.getOutputLocation().equals((Object)project.getFullPath())) {
                                file2 = project.getFile(filename);
                                ret.add(cp.getOutputLocation().toString());
                                if (file2.exists()) {
                                    return ret;
                                }
                            } else {
                                folder = root.getFolder(cp.getOutputLocation());
                                file = folder.getFile(filename);
                                ret.add(folder.toString());
                                if (file.exists()) {
                                    return ret;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (javaProject.getOutputLocation().equals((Object)project.getFullPath())) {
                    IFile file3 = project.getFile(filename);
                    ret.add(javaProject.getOutputLocation().toString());
                    if (file3.exists()) {
                        return ret;
                    }
                } else if (!sourceOnly) {
                    IFolder folder2 = root.getFolder(javaProject.getOutputLocation());
                    IFile file4 = folder2.getFile(filename);
                    ret.add(folder2.toString());
                    if (file4.exists()) {
                        return ret;
                    }
                }
            } else {
                MyResourceVisitor visitor = new MyResourceVisitor(filename, null, DEFAULT_OUT_FOLDERS);
                project.accept((IResourceVisitor)visitor);
                if (visitor.getFoundFile() != null) {
                    ret.add(visitor.getFoundFile().toString());
                    return ret;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return ret;
    }

    public static void checkNatures(IProject project) {
        String[] natureIds;
        if (project == null) {
            return;
        }
        log.debug("checking natures for project {}", (Object)project.getName());
        String[] stringArray = natureIds = new String[]{"org.zeroturnaround.eclipse.jrebelNature", "org.zeroturnaround.eclipse.remoting.remotingNature", "org.eclipse.jdt.core.javanature", MAVEN_NATURE_ID, "org.eclipse.wst.common.project.facet.core.nature", "org.eclipse.wst.common.modulecore.ModuleCoreNature"};
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            log.debug("has nature {}: {}", (Object)natureId, (Object)ProjectHelper.hasNature(project, natureId));
            ++n2;
        }
    }

    public static boolean isEligibleForJRebel(IProject project) {
        return ProjectHelper.isJavaProject(project) || ProjectHelper.isEarProject(project);
    }

    public static void deleteWithBackup(IProject project, IFile xml) {
        if (xml != null) {
            try {
                if (!xml.isLinked()) {
                    RebelConfBackupUtil.backupToProject((File)project.getLocation().toFile(), (File)xml.getLocation().toFile(), (RebelConfBackupUtil.Product)RebelConfBackupUtil.Product.ECLIPSE);
                }
                xml.delete(true, false, null);
            }
            catch (CoreException e) {
                log.error((Throwable)e);
            }
        }
    }

    @NotNull
    public static List<EclipseIdeProject> getJRebelEclipseModules() {
        ArrayList<EclipseIdeProject> result = new ArrayList<EclipseIdeProject>();
        for (IdeModule module : IdeInstance.getInstance().getModules()) {
            if (!module.isJRebelEnabled()) continue;
            result.add((EclipseIdeProject)module);
        }
        return result;
    }
}

