/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ProjectNatureUtil {
    private static final Log log = Log.getInstance(ProjectNatureUtil.class);

    public static void addNatureTo(IProject project, IProgressMonitor monitor, String natureId) {
        log.info("Adding nature {} to {}", (Object)natureId, (Object)project.getName());
        if (!project.isOpen()) {
            log.info("Project is closed, skipping adding nature");
            return;
        }
        try {
            String[] natures;
            IProjectDescription description = project.getDescription();
            String[] stringArray = natures = description.getNatureIds();
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                log.debug("Project {} has nature {}", (Object)project, (Object)nature);
                if (nature.equals(natureId)) {
                    return;
                }
                ++n2;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, 0, monitor);
        }
        catch (CoreException e) {
            String msg = String.format("Unable to add nature to project: '%s', %s", project, natureId);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static void removeNatureFrom(IProject project, IProgressMonitor monitor, String natureId) {
        log.info("Removing nature {} from {}", (Object)natureId, (Object)project.getName());
        if (!project.isOpen()) {
            log.info("Project is closed, skipping removing nature");
            return;
        }
        try {
            IProjectDescription description = project.getDescription();
            ArrayList<String> natures = new ArrayList<String>();
            natures.addAll(Arrays.asList(description.getNatureIds()));
            Iterator iter = natures.iterator();
            while (iter.hasNext()) {
                String nature = (String)iter.next();
                if (!nature.equals(natureId)) continue;
                iter.remove();
            }
            String[] newNatures = natures.toArray(new String[natures.size()]);
            description.setNatureIds(newNatures);
            project.setDescription(description, 0, monitor);
        }
        catch (CoreException e) {
            String msg = String.format("Unable to remove nature from project: '%s', %s", project, natureId);
            throw new IllegalArgumentException(msg, e);
        }
    }
}

