/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.util.EclipseConstantsStringifier;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.utils.SystemUtils;

public class RebelXmlBuilder
extends IncrementalProjectBuilder {
    private static final Log log = Log.getInstance(RebelXmlBuilder.class);
    public static final String BUILDER_ID = "org.zeroturnaround.eclipse.rebelXmlBuilder";
    private AtomicBoolean isFirstBuild = new AtomicBoolean(false);

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        JRebelProject rebelProject = ProjectHelper.getJRebelProject(project);
        if (rebelProject == null || rebelProject.isJRebelDisabled()) {
            return null;
        }
        if (this.isFirstBuild.compareAndSet(false, true) || kind == 6 || kind == 10) {
            if (!new EclipseIdeProject(project).isIdeRebelXmlGenerationType()) {
                log.trace("Trying to generate external rebel.xml");
                if (this.isEligibleForExternalGen(project)) {
                    this.generateExternalRebelXml(project, false);
                }
                return null;
            }
            RebelXmlGenerator generator = RebelXmlGenerator.forProject(project);
            generator.generate(rebelProject.getXmlGeneratorInput(), true, "Invoked " + EclipseConstantsStringifier.getIncrementalProjectBuilderKind(kind));
        } else {
            log.trace("Invoked " + EclipseConstantsStringifier.getIncrementalProjectBuilderKind(kind) + " for JRebel-enabled project " + project.getName());
        }
        return null;
    }

    public void generateExternalRebelXml(IProject project, boolean forceNew) {
        log.trace("Trying to generate external rebel.xml");
        if (this.isEligibleForExternalGen(project)) {
            try {
                File rebelXml = this.getTempRebelXmlFile(project, forceNew);
                this.writeRebelXmlToTarget(project, rebelXml);
                this.createLinkInSource(project, rebelXml, forceNew);
            }
            catch (Exception e) {
                log.warn("Failed to create linked resource into source for project {}", (Object)project.getName(), (Object)e);
            }
        }
    }

    private File getTempRebelXmlFile(IProject project, boolean forceNew) throws IOException, CoreException {
        QualifiedName tempRebelXml = new QualifiedName("rebel.ide-external.temp-file", "org.zeroturnaround.eclipse.jrebel");
        if (!forceNew && project.getSessionProperty(tempRebelXml) != null) {
            return (File)project.getSessionProperty(tempRebelXml);
        }
        File tempDirectory = JRebelConfiguration.getDefault().getTempDirectory();
        String projectSafeName = SystemUtils.ensurePathAndURLSafeName((String)project.getName());
        File folder = File.createTempFile("rebelxml-" + projectSafeName, "", tempDirectory);
        folder.delete();
        File file = new File(folder, "rebel.xml");
        project.setSessionProperty(tempRebelXml, (Object)file);
        return file;
    }

    private void createLinkInSource(IProject project, File rebelXml, boolean forceNew) throws CoreException {
        IFile file = this.getRebelXml(project);
        if (forceNew && file.exists() && file.isLinked()) {
            log.debug("Deleted existing rebel.xml as it is force regeneration (project: {})", (Object)project.getName());
            file.delete(true, false, null);
        } else if (file.isLinked() && !file.getLocation().toFile().exists()) {
            log.debug("Deleted existing rebel.xml as as linked target does not exist");
            file.delete(true, false, null);
        }
        if (!file.exists()) {
            file.createLink((IPath)new Path(rebelXml.getAbsolutePath()), 0, null);
            log.info("Created linked resource at {} linking to {} for project {}", new Object[]{file, rebelXml, project});
        }
    }

    public IFile getRebelXml(IProject project) {
        IContainer folder = this.getRebeXmlSourceFolder(project);
        return folder.getFile((IPath)new Path("rebel.xml"));
    }

    private IContainer getRebeXmlSourceFolder(IProject project) {
        JRebelProject jrebelProject = new JRebelProject(project);
        return jrebelProject.getRebelXmlTargetFolder();
    }

    private boolean isEligibleForExternalGen(IProject project) {
        return ProjectHelper.isJavaProject(project);
    }

    private void writeRebelXmlToTarget(IProject project, File rebelXml) throws IOException {
        if (!rebelXml.exists()) {
            File parentFile = rebelXml.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            EclipseIdeProject module = new EclipseIdeProject(project);
            FileUtils.writeStringToFile((File)rebelXml, (String)module.getSavedRebelXmlContent());
            log.info("Wrote rebel.xml base on stored file to {} for project {}", (Object)rebelXml, (Object)project);
        }
    }
}

