/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import org.eclipse.core.resources.IProject;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.actions.extension.IGradleProjectInfo;
import org.zeroturnaround.eclipse.actions.extension.IMavenProjectInfo;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.javarebel.preferences.Preferences;
import org.zeroturnaround.javarebel.preferences.PreferencesTransaction;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.preferences.PreferencesWrapper;
import org.zeroturnaround.jrebel.ide.common.remote.RebelRemoteModuleName;

public class RemoteModuleName {
    private static final Log log = Log.getInstance(RemoteModuleName.class);

    @NotNull
    public static String getRemoteId(@NotNull IProject project) {
        String remoteId;
        IMavenProjectInfo mavenProjectInfo = Hooks.getHookOpt(IMavenProjectInfo.class, "org.zeroturnaround.rebel.maven.info");
        IGradleProjectInfo gradleProjectInfo = Hooks.getHookOpt(IGradleProjectInfo.class, "org.zeroturnaround.rebel.gradle.info");
        if (ProjectHelper.isMavenProject(project) && mavenProjectInfo != null) {
            remoteId = RemoteModuleName.getMavenRemoteId(mavenProjectInfo, project);
        } else if (ProjectHelper.isGradleProject(project) && gradleProjectInfo != null) {
            remoteId = RemoteModuleName.getGradleRemoteId(gradleProjectInfo, project);
        } else {
            remoteId = RebelRemoteModuleName.constructModuleName((String)project.getName(), null, null);
            RemoteModuleName.storeRemoteIdMetrics(project.getName(), null, null, "none");
            log.info("Module {} is not detected as gradle or maven for remote id generation", (Object)project);
        }
        return RebelRemoteModuleName.sanitizeName((String)remoteId);
    }

    private static String getMavenRemoteId(IMavenProjectInfo mavenProjectInfo, IProject project) {
        String groupId = mavenProjectInfo.getMavenGroupId(project);
        String artifactId = mavenProjectInfo.getMavenArtifactId(project);
        log.info("Calculating remote id using maven from module name '{}', group '{}', artifactId '{}'", new Object[]{project.getName(), groupId, artifactId});
        RemoteModuleName.storeRemoteIdMetrics(project.getName(), groupId, artifactId, "maven");
        return RebelRemoteModuleName.constructModuleName((String)project.getName(), (String)groupId, (String)artifactId);
    }

    private static String getGradleRemoteId(IGradleProjectInfo gradleProjectInfo, IProject project) {
        String groupId = gradleProjectInfo.getGroupId(project);
        String artifactId = gradleProjectInfo.getArtifactId(project);
        log.info("Calculating remote id using gradle from module name '{}', group '{}', artifactId '{}'", new Object[]{project.getName(), groupId, artifactId});
        RemoteModuleName.storeRemoteIdMetrics(project.getName(), groupId, artifactId, "gradle");
        return RebelRemoteModuleName.constructModuleName((String)project.getName(), null, null);
    }

    private static void storeRemoteIdMetrics(String moduleName, String groupId, String artifactId, String idSource) {
        Preferences prefs = PreferencesWrapper.getInstance().getPrefs();
        prefs.run(new PreferencesTransaction().put("ide.rebel-xml.id.source", idSource).put("ide.rebel-xml.groupid.available", Boolean.toString(groupId != null && !groupId.isEmpty())).put("ide.rebel-xml.artifactid.available", Boolean.toString(artifactId != null && !artifactId.isEmpty())).put("ide.rebel-xml.artifactid.match", Boolean.toString(moduleName.equals(artifactId))));
    }
}

