/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.notifications.RedeployProjectNotification;

public class ToggleJRebelNatureAction
implements IObjectActionDelegate {
    private static final Log log = Log.getInstance(ToggleJRebelNatureAction.class);
    private ISelection selection;

    public void run(IAction action) {
        IProject project = this.getSelectedProject();
        if (project != null) {
            this.toggleNature(project);
        }
        this.updateDescription(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.updateDescription(action);
    }

    private void updateDescription(IAction action) {
        IProject project = this.getSelectedProject();
        if (project != null) {
            boolean isJRebelProject = ProjectHelper.isJRebelProject(project);
            action.setText(isJRebelProject ? "Disable JRebel" : "Enable JRebel");
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.updateDescription(action);
    }

    private void toggleNature(IProject project) {
        boolean wasEnabled = ProjectHelper.isJRebelProject(project);
        try {
            JRebelProject.updateJRebelEnablement(project, !wasEnabled, (IProgressMonitor)new NullProgressMonitor());
            if (!wasEnabled) {
                RedeployProjectNotification.show((boolean)false);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    private IProject getSelectedProject() {
        return RebelXmlGenerator.getProjectFromSelection(this.selection);
    }
}

