/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.enable;

import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import com.zeroturnaround.jrebel.ide.common.IdeModule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.eclipse.dialog.JRebelAutoEnableDialog;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNaturePilot;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNatureTask;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableState;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.preferences.Preferences;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.preferences.PreferencesWrapper;
import org.zeroturnaround.jrebel.client.startup.SharedScheduler;

public class AutoEnableNatureFeature {
    private static final Log log = Log.getInstance(AutoEnableNatureFeature.class);
    static final String KEY_HAS_RAN_AUTOENABLE_PROJECT_STANDALONE = "com.zeroturnaround.jrebel.autoenable.project.HasEnabledStandalone";
    static final String KEY_HAS_RAN_AUTOENABLE_WORKSPACE = "com.zeroturnaround.jrebel.autoenable.workspace.HasEnabled";
    static final String KEY_HAS_RAN_AUTOENABLE_PROJECT = "com.zeroturnaround.jrebel.autoenable.project.HasEnabled";
    static final String FEATURE_DELIVERED_WITH_UPDATE = "ide.project.auto-enable.get_with_update";
    private static IResourceChangeListener projectListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            log.trace("Workspace updated, search for added projects");
            try {
                final ArrayList<IProject> addedProjects = new ArrayList<IProject>();
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        int type = resource.getType();
                        if (type == 8) {
                            return true;
                        }
                        if (type == 4 && delta.getKind() == 1) {
                            IProject project = resource.getProject();
                            addedProjects.add(project);
                            log.debug("New project found, add for autoenabling {}", (Object)resource);
                        }
                        return false;
                    }
                });
                if (!addedProjects.isEmpty()) {
                    AutoEnableNatureFeature.enableJRebelForNewProjects(addedProjects);
                }
            }
            catch (CoreException e) {
                log.warn((Throwable)e);
            }
        }
    };

    public static void start() {
        if (!AutoEnableNaturePilot.isInPilot()) {
            return;
        }
        AutoEnableNatureFeature.initAutoEnableStateListener();
        if (AutoEnableNatureFeature.isDisabled()) {
            return;
        }
        log.trace("Add project listener");
        EclipseUtil.getWorkspace().addResourceChangeListener(projectListener, 1);
        if (AutoEnableNatureFeature.jRebelWasInstalledBefore()) {
            log.info("JRebel was installed before this feature was delivered, skip processing workspaces");
            return;
        }
        SharedScheduler.getExecutor().execute(AutoEnableNatureFeature::convertWorkspace);
    }

    public static boolean isDisabled() {
        return AutoEnableState.fromConfig() == AutoEnableState.NEVER;
    }

    private static boolean jRebelWasInstalledBefore() {
        return PreferencesWrapper.getInstance().getPrefs().snapshot().getBoolean(FEATURE_DELIVERED_WITH_UPDATE, false);
    }

    private static void convertWorkspace() {
        log.info("Current workspace: {}", (Object)EclipseUtil.getWorkspaceRoot());
        if (AutoEnableNatureFeature.isWorkspaceProcessed()) {
            log.debug("Has ran autoenable for this workspace before");
            return;
        }
        log.trace("Create task");
        List modules = IdeInstance.getInstance().getModules();
        log.trace("Modules: {}", (Object)modules);
        AutoEnableNatureTask task = new AutoEnableNatureTask(AutoEnableNatureTask.ConvertSource.STARTUP, modules);
        log.trace("Task created");
        if (task.anyHasJRebelEnabled()) {
            log.info("At least one project has JRebel enabled, skipping");
        } else if (task.anyHasBeenAutoEnabledBefore()) {
            log.info("At least one project was auto-enabled, skipping");
        } else if (!task.hasProjectsToConvert()) {
            log.info("No projects found that need to autoenable JRebel, skip");
        } else {
            log.debug("Schedule showing dialog for workspace");
            EclipseUtil.runInUiThread(() -> {
                log.debug("Show dialog for workspace");
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                JRebelAutoEnableDialog.askForWorkspace(shell, result -> {
                    log.info("Dialog answer for workspace is {}", (Object)result);
                    if (result) {
                        task.createJob().schedule();
                    }
                    IdeInstance.getInstance().storage().setProperty(KEY_HAS_RAN_AUTOENABLE_WORKSPACE, true);
                });
            });
        }
    }

    private static void initAutoEnableStateListener() {
        AutoEnableState.configOption(JRebelConfiguration.getDefault()).addValueChangedListener((IValueChangedListener)new IValueChangedListener<AutoEnableState>(){

            public void valueChanged(IOption<AutoEnableState> option) {
                if (option.getValue() == AutoEnableState.NEVER) {
                    log.trace("Remove project listener");
                    EclipseUtil.getWorkspace().removeResourceChangeListener(projectListener);
                } else {
                    log.trace("Re-add project listener");
                    EclipseUtil.getWorkspace().addResourceChangeListener(projectListener, 1);
                }
            }
        });
    }

    @NotNull
    public static boolean isWorkspaceProcessed() {
        return IdeInstance.getInstance().storage().getProperty(KEY_HAS_RAN_AUTOENABLE_WORKSPACE, false);
    }

    public static void enableJRebelForNewProjects(List<IProject> projects) {
        if (!AutoEnableNaturePilot.isInPilot()) {
            return;
        }
        if (AutoEnableNatureFeature.isDisabled()) {
            return;
        }
        List<IdeModule> modules = EclipseUtil.toIdeModules(projects);
        final AutoEnableNatureTask task = new AutoEnableNatureTask(AutoEnableNatureTask.ConvertSource.LISTENER, modules);
        if (!task.hasProjectsToConvert()) {
            log.debug("No projects found that need to autoenable JRebel, skip");
            return;
        }
        log.trace("Projects found to be enabled, schedule asking user in UI thread");
        EclipseUtil.runInUiThread(new Runnable(){

            @Override
            public void run() {
                log.debug("Show dialog for project");
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                JRebelAutoEnableDialog.askForNewProject(shell, result -> {
                    log.info("Dialog answer for project is {}", (Object)result);
                    if (result) {
                        task.createJob().schedule();
                    }
                });
            }
        });
    }

    public static void migration(boolean freshInstall) {
        if (AutoEnableNaturePilot.isInPilot()) {
            log.debug("Do migration, freshInstall={}", (Object)freshInstall);
            Preferences prefs = PreferencesWrapper.getInstance().getPrefs();
            if (!prefs.snapshot().containsKey(FEATURE_DELIVERED_WITH_UPDATE)) {
                log.debug("Set {} flag to {}", (Object)FEATURE_DELIVERED_WITH_UPDATE, (Object)(!freshInstall ? 1 : 0));
                prefs.putBoolean(FEATURE_DELIVERED_WITH_UPDATE, !freshInstall);
            }
        }
    }
}

