/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.enable;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.common.util.MetricsUtil;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNaturePilot;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableState;
import org.zeroturnaround.eclipse.util.EclipseMetricsUtil;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.javarebel.preferences.Preferences;
import org.zeroturnaround.javarebel.preferences.PreferencesSnapshot;
import org.zeroturnaround.javarebel.preferences.PreferencesTransaction;
import org.zeroturnaround.javarebel.reporting.MessageType;
import org.zeroturnaround.javarebel.reporting.Metrics;
import org.zeroturnaround.javarebel.reporting.interceptors.MessageInterceptor;
import org.zeroturnaround.javarebel.reporting.interceptors.MessageInterceptorChain;
import org.zeroturnaround.javarebel.reporting.model.JRebelMetadata;
import org.zeroturnaround.javarebel.reporting.model.ReportMessage;
import org.zeroturnaround.javarebel.reporting.model.UserMetadata;
import org.zeroturnaround.javarebel.reporting.model.builder.MessageBuilder;
import org.zeroturnaround.jrebel.client.metrics.IdeMetricsInstance;
import org.zeroturnaround.jrebel.client.preferences.PreferencesWrapper;

public class AutoEnableNatureMetrics {
    private static final String PREFS_KEY_LAST_RESET_TIME = "ide.project.throttle.last-reset-time";
    private static final String PREFS_KEY_SEND_COUNT_SINCE_RESET = "ide.project.throttle.send-count-since-reset";
    private static final String PREFS_KEY_PROJECTS_UPDATED_TOTAL = "ide.project.auto-enable-count";
    private static final String PREFS_KEY_LAST_PROJECT_UPDATE_TIME = "ide.project.auto-enable-time";
    private final Metrics metrics = IdeMetricsInstance.getInstance();
    private final Preferences preferences = PreferencesWrapper.getInstance().getPrefs();

    AutoEnableNatureMetrics() {
    }

    void sendEvent(List<EclipseIdeProject> projects) {
        ThrottlingInterceptor interceptor = new ThrottlingInterceptor();
        IdeProjectConfigMessageBuilder messageBuilder = new IdeProjectConfigMessageBuilder(projects);
        this.metrics.sendMessage((MessageBuilder)messageBuilder, Collections.singletonList(interceptor));
    }

    public static Map<String, Object> getStatsEventMetrics() {
        if (!AutoEnableNaturePilot.isInPilot()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        PreferencesSnapshot snapshot = PreferencesWrapper.getInstance().getPrefs().snapshot();
        result.put(PREFS_KEY_PROJECTS_UPDATED_TOTAL, snapshot.getInt(PREFS_KEY_PROJECTS_UPDATED_TOTAL, 0));
        String lastEnableTimestampString = null;
        long lastEnableTimestamp = snapshot.getLong(PREFS_KEY_LAST_PROJECT_UPDATE_TIME, 0L);
        if (lastEnableTimestamp > 0L) {
            lastEnableTimestampString = MetricsUtil.toMixPanelDateFormat((long)lastEnableTimestamp);
        }
        result.put(PREFS_KEY_LAST_PROJECT_UPDATE_TIME, lastEnableTimestampString);
        result.put("ide.autoenable", AutoEnableNatureMetrics.getPropertyState());
        return result;
    }

    @NotNull
    private static String getPropertyState() {
        return AutoEnableState.fromConfig().propertyValue;
    }

    void updateCountPrefs() {
        PreferencesSnapshot snapshot = this.preferences.snapshot();
        this.preferences.run(new PreferencesTransaction().putInt(PREFS_KEY_PROJECTS_UPDATED_TOTAL, snapshot.getInt(PREFS_KEY_PROJECTS_UPDATED_TOTAL, 0) + 1).putLong(PREFS_KEY_LAST_PROJECT_UPDATE_TIME, System.currentTimeMillis()));
    }

    protected static class IdeProjectConfigMessageBuilder
    implements MessageBuilder {
        private final List<EclipseIdeProject> projects;

        public IdeProjectConfigMessageBuilder(List<EclipseIdeProject> projects) {
            this.projects = projects;
        }

        public ReportMessage build(Licensing.SDKLicenseInfo info, UserMetadata userMetadata, JRebelMetadata jRebelMetadata) {
            return new ReportMessage(MessageType.IdeProjectConfig, info).add("project-type", (Object)"web").add("project-enabled", (Object)true).add("project.count", (Object)this.projects.size()).add("source", (Object)"auto-enable").add("workspace", (Object)EclipseMetricsUtil.getWorkspaceLocationHash()).addIfNotNull("project-name", this.projects.size() == 1 ? EclipseMetricsUtil.getNameHash(this.projects.get(0).getEclipseProject()) : null);
        }
    }

    protected class ThrottlingInterceptor
    implements MessageInterceptor {
        protected ThrottlingInterceptor() {
        }

        public void send(ReportMessage message, MessageInterceptorChain chain) throws Exception {
            PreferencesSnapshot beforeSendPrefsSnapshot = AutoEnableNatureMetrics.this.preferences.snapshot();
            long lastResetTime = beforeSendPrefsSnapshot.getLong(AutoEnableNatureMetrics.PREFS_KEY_LAST_RESET_TIME, 0L);
            if (lastResetTime + TimeUnit.DAYS.toMillis(1L) <= System.currentTimeMillis()) {
                AutoEnableNatureMetrics.this.preferences.run(new PreferencesTransaction().putLong(AutoEnableNatureMetrics.PREFS_KEY_LAST_RESET_TIME, System.currentTimeMillis()).putInt(AutoEnableNatureMetrics.PREFS_KEY_SEND_COUNT_SINCE_RESET, 0));
            } else if (beforeSendPrefsSnapshot.getInt(AutoEnableNatureMetrics.PREFS_KEY_SEND_COUNT_SINCE_RESET, 0) >= 10) {
                return;
            }
            chain.send(message);
            AutoEnableNatureMetrics.this.preferences.putInt(AutoEnableNatureMetrics.PREFS_KEY_SEND_COUNT_SINCE_RESET, AutoEnableNatureMetrics.this.preferences.getInt(AutoEnableNatureMetrics.PREFS_KEY_SEND_COUNT_SINCE_RESET, 0) + 1);
        }
    }
}

