/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.enable;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.actions.ExternalBuildRebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNatureMetrics;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;

public class AutoEnableNatureTask {
    private static final Log log = Log.getInstance(AutoEnableNatureTask.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(AutoEnableNatureTask.class);
    private final AutoEnableNatureMetrics autoEnableNatureMetrics = new AutoEnableNatureMetrics();
    private final List<EclipseIdeProject> modulesEnabled = new ArrayList<EclipseIdeProject>();
    private final List<EclipseIdeProject> modulesToProcess = new ArrayList<EclipseIdeProject>();
    private final ConvertSource convertSource;

    public AutoEnableNatureTask(ConvertSource convertSource, List<IdeModule> modules) {
        this.convertSource = convertSource;
        for (IdeModule module : modules) {
            this.modulesToProcess.add((EclipseIdeProject)module);
        }
    }

    public Job createJob() {
        log.debug("Create new job from {}", (Object)this.convertSource);
        return new Job("Enable JRebel for projects"){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    public boolean hasProjectsToConvert() {
        for (EclipseIdeProject project : this.modulesToProcess) {
            ConvertStatus status = this.projectStatus(project);
            log.debug("Project {} status: {}, source: {}", new Object[]{project, status, this.convertSource});
            if (status != ConvertStatus.WEB) continue;
            return true;
        }
        return false;
    }

    private void enableJRebelIfPossible(EclipseIdeProject project) {
        ConvertStatus status = this.projectStatus(project);
        log.debug("Project {} status: {}, source: {}", new Object[]{project, status, this.convertSource});
        if (status == ConvertStatus.WEB || status == ConvertStatus.STANDALONE) {
            try {
                log.info("Will enable JRebel for {}", (Object)project);
                JRebelProject.updateJRebelEnablement(project.getEclipseProject(), true, (IProgressMonitor)new NullProgressMonitor());
                this.modulesEnabled.add(project);
                this.autoEnableNatureMetrics.updateCountPrefs();
                consoleLog.info("JRebel was enabled for project {}. This added rebel.xml configuration file to project.\nTo revert, uncheck this project from JRebel > Configuration > Projects.\nAutoenabling can be disabled from JRebel > Configuration > Advanced.", (Object)project.getName());
            }
            finally {
                project.storage().setProperty("com.zeroturnaround.jrebel.autoenable.project.HasEnabled", true);
            }
        }
    }

    public List<EclipseIdeProject> getModulesEnabled() {
        return this.modulesEnabled;
    }

    ConvertStatus projectStatus(EclipseIdeProject project) {
        if (!project.isEligibleForJRebel()) {
            return ConvertStatus.NON_ELIGIBLE;
        }
        if (project.isJRebelProject()) {
            return ConvertStatus.ALREADY_JREBEL;
        }
        if (ExternalBuildRebelXmlGenerator.canGenerateWithExternalBuildTool(project.getEclipseProject())) {
            return ConvertStatus.EXTERNAL_JREBEL_CONFIGURED;
        }
        if (AutoEnableNatureTask.hasBeenConvertedBefore(project)) {
            return ConvertStatus.ALREADY_CONVERTED;
        }
        if (project.isStandaloneProject()) {
            return ConvertStatus.STANDALONE;
        }
        return ConvertStatus.WEB;
    }

    private static boolean hasBeenConvertedBefore(EclipseIdeProject project) {
        return project.storage().getProperty("com.zeroturnaround.jrebel.autoenable.project.HasEnabled", false) || project.storage().getProperty("com.zeroturnaround.jrebel.autoenable.project.HasEnabledStandalone", false);
    }

    public boolean anyHasJRebelEnabled() {
        for (IdeModule ideModule : this.modulesToProcess) {
            if (!ideModule.isJRebelEnabled()) continue;
            log.debug("{} has JRebel enabled", (Object)ideModule);
            return true;
        }
        return false;
    }

    public boolean anyHasBeenAutoEnabledBefore() {
        for (EclipseIdeProject module : this.modulesToProcess) {
            if (!AutoEnableNatureTask.hasBeenConvertedBefore(module)) continue;
            log.debug("{} has been autoenabled before", (Object)module);
            return true;
        }
        return false;
    }

    static /* synthetic */ List access$0(AutoEnableNatureTask autoEnableNatureTask) {
        return autoEnableNatureTask.modulesToProcess;
    }

    static /* synthetic */ Log access$1() {
        return log;
    }

    static /* synthetic */ AutoEnableNatureMetrics access$2(AutoEnableNatureTask autoEnableNatureTask) {
        return autoEnableNatureTask.autoEnableNatureMetrics;
    }

    static /* synthetic */ List access$3(AutoEnableNatureTask autoEnableNatureTask) {
        return autoEnableNatureTask.modulesEnabled;
    }

    static /* synthetic */ ConvertSource access$4(AutoEnableNatureTask autoEnableNatureTask) {
        return autoEnableNatureTask.convertSource;
    }

    static /* synthetic */ void access$5(AutoEnableNatureTask autoEnableNatureTask, EclipseIdeProject eclipseIdeProject) {
        autoEnableNatureTask.enableJRebelIfPossible(eclipseIdeProject);
    }

    public static enum ConvertSource {
        LISTENER,
        STARTUP;

    }

    public static enum ConvertStatus {
        NON_ELIGIBLE,
        ALREADY_JREBEL,
        EXTERNAL_JREBEL_CONFIGURED,
        ALREADY_CONVERTED,
        STANDALONE,
        WEB,
        UNKNOWN;

    }
}

