/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.enable;

import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.common.options.ComputedOption;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.Option;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;

public enum AutoEnableState {
    ASK("ask", "Ask"),
    NEVER("never", "Never"),
    ALWAYS("always", "Always");

    private static final Log log;
    public final String propertyValue;
    public final String uiName;

    static {
        log = Log.getInstance(AutoEnableState.class);
    }

    private AutoEnableState(String propertyValue, String uiName) {
        this.propertyValue = propertyValue;
        this.uiName = uiName;
    }

    private static AutoEnableState fromString(String value) {
        log.trace("Feature state: {}", (Object)value);
        if (value != null) {
            AutoEnableState[] autoEnableStateArray = AutoEnableState.values();
            int n = autoEnableStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                AutoEnableState state = autoEnableStateArray[n2];
                if (state.propertyValue.equalsIgnoreCase(value)) {
                    return state;
                }
                ++n2;
            }
        }
        return ASK;
    }

    public static AutoEnableState fromConfig() {
        return (AutoEnableState)((Object)AutoEnableState.configOption(JRebelConfiguration.getDefault()).getValue());
    }

    public void save() {
        AutoEnableState.configOption(JRebelConfiguration.getDefault()).setValue((Object)this);
    }

    public int listIndex() {
        return this.ordinal();
    }

    @Nullable
    public static AutoEnableState fromListIndex(int index) {
        AutoEnableState[] values = AutoEnableState.values();
        if (index < 0 || index >= values.length) {
            return null;
        }
        return values[index];
    }

    public static IOption<AutoEnableState> configOption(JRebelConfiguration configuration) {
        Option option = configuration.autoEnableSavedForProjects();
        return new ComputedOption<AutoEnableState, String>((IOption)option){

            public AutoEnableState apply(String value) {
                AutoEnableState state = AutoEnableState.fromString(value);
                log.trace("Resolved feature state: {}", (Object)state);
                return state;
            }

            public String unapply(AutoEnableState value) {
                log.debug("Save state property: {}", (Object)value.propertyValue);
                return value.propertyValue;
            }
        };
    }
}

