/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.property;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class ProjectProperty<T> {
    private static final Log log = Log.getInstance(ProjectProperty.class);
    private final T defaultValue;
    private final QualifiedName name;

    public ProjectProperty(QualifiedName name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public T get(IProject project) {
        try {
            String value = project.getPersistentProperty(this.name);
            if (value == null) {
                return this.defaultValue;
            }
            return this.parseValue(value);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return this.defaultValue;
        }
    }

    public void clean(IProject project) {
        log.trace("clean for project " + project.getName() + " and property " + this.name.toString());
        try {
            project.setPersistentProperty(this.name, null);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    abstract T parseValue(String var1);

    abstract String toStringValue(T var1);

    public void set(IProject project, T value) {
        String asString = this.toStringValue(value);
        log.trace("set for project " + project.getName() + " and property " + this.name.toString() + ". New value " + asString);
        try {
            project.setPersistentProperty(this.name, asString);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }
}

