/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.rebelconf;

import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.rebelconf.AbstractRebelXmlGeneration;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationSource;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationTask;
import org.zeroturnaround.eclipse.util.EclipseJob;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.feature.external.RebelXmlAction;
import org.zeroturnaround.jrebel.client.feature.external.SharedExternalAutoConvert;
import org.zeroturnaround.jrebel.client.feature.external.SharedRebelXmlGeneration;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;
import org.zeroturnaround.jrebel.client.startup.SharedScheduler;
import org.zeroturnaround.jrebel.ide.common.notifications.feature.NotificationLinkListener;

public class ExternalAutoConvert
extends AbstractRebelXmlGeneration
implements Runnable {
    private static final Log log = JRebelClientAdapter.getInstance().getLogger(ExternalAutoConvert.class);
    private final RebelXmlGenerationSource generator = new RebelXmlGenerationSource();

    public void start() {
        SharedScheduler.getExecutor().execute(this);
    }

    @Override
    public void run() {
        boolean isDisabled = IdeInstance.getInstance().isExternalAutoconvertDisabled();
        log.debug("{} is disabled: {}", (Object)this.getClass().getSimpleName(), (Object)isDisabled);
        if (isDisabled) {
            log.debug("not converting anything because disabled");
            return;
        }
        List<EclipseIdeProject> candidateModules = this.getCandidateModules();
        if (candidateModules.size() == 0) {
            return;
        }
        List<EclipseIdeProject> converted = this.generator.convertToExternalGenerationBlockingAutoConvert(candidateModules);
        if (converted.isEmpty()) {
            log.warn("Initial rebel.xml generation succeeded but second pass failed for {}", candidateModules);
            return;
        }
        int updated = converted.size();
        SharedRebelXmlGeneration.logConvertedSummary((int)updated, (boolean)false);
        SharedExternalAutoConvert.sendNotification(converted, (NotificationLinkListener)this.getUndoTask(candidateModules));
    }

    @NotNull
    private NotificationLinkListener getUndoTask(final @NotNull List<EclipseIdeProject> modules) {
        return new NotificationLinkListener(){
            AtomicBoolean hasRun = new AtomicBoolean(false);

            public void onClick() {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!hasRun.getAndSet(true)) {
                            log.debug("Will undo changes as user clicked on notification");
                            int updated = ExternalAutoConvert.this.generator.convertToIdeGenerationBlocking(modules, RebelXmlAction.AUTOCONVERT_UNDO);
                            SharedRebelXmlGeneration.logConvertedSummary((int)updated, (boolean)true);
                        } else {
                            log.debug("Already run with provided modules - noop");
                        }
                    }
                }, "rebel-ide-autoconvert-undo");
                t.setDaemon(true);
                t.start();
            }
        };
    }

    List<EclipseIdeProject> getCandidateModules() {
        List<EclipseIdeProject> modules = ProjectHelper.getJRebelEclipseModules();
        return SharedExternalAutoConvert.filterModules(modules, candidates -> this.filterProjectsWithJRebelPlugin(candidates));
    }

    private List<EclipseIdeProject> filterProjectsWithJRebelPlugin(final List<EclipseIdeProject> modules) {
        final ArrayList<EclipseIdeProject> modulesToConvert = new ArrayList<EclipseIdeProject>();
        EclipseJob job = new EclipseJob(){

            @Override
            public String getName() {
                return "Checking external plugin compatibility";
            }

            @Override
            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Checking projects", -1);
                modulesToConvert.addAll(this.getProjectsWithRebelXmlGenerationSupport(modules, monitor));
            }

            private List<EclipseIdeProject> getProjectsWithRebelXmlGenerationSupport(List<EclipseIdeProject> modules2, IProgressMonitor monitor) {
                ArrayList<EclipseIdeProject> result = new ArrayList<EclipseIdeProject>();
                for (EclipseIdeProject module : modules2) {
                    String moduleName = module.getName();
                    monitor.subTask("Checking project " + moduleName);
                    try {
                        RebelXmlGenerationTask.generateBuildToolRebelXml(module);
                        result.add(module);
                        log.debug("Project {} has JRebel plugin", (Object)moduleName);
                    }
                    catch (Exception e) {
                        log.debug("Could not generate rebel.xml for project {} - {}", (Object)moduleName, (Object)e.getMessage());
                        module.updateLastExternalCheckFailedTimestamp();
                    }
                }
                return result;
            }
        };
        EclipseUtil.runJobsBlocking(Collections.singletonList(job));
        return modulesToConvert;
    }
}

