/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.rebelconf;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.actions.ExternalBuildRebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.rebelconf.AbstractRebelXmlGeneration;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationMetrics;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationTask;
import org.zeroturnaround.eclipse.util.EclipseJob;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.feature.external.RebelXmlAction;
import org.zeroturnaround.jrebel.client.feature.external.SharedRebelXmlGeneration;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;
import org.zeroturnaround.jrebel.client.xmlgen.BuildTool;

public class RebelXmlGenerationSource
extends AbstractRebelXmlGeneration {
    private static final Log log = JRebelClientAdapter.getInstance().getLogger(RebelXmlGenerationSource.class);
    private static final ConsoleLog consolelog = ConsoleLog.getInstance(RebelXmlGenerationSource.class);
    private static final int MAX_CONCURRENT_ECLIPSE_JOBS = 15;
    private final RebelXmlGenerationMetrics generator = new RebelXmlGenerationMetrics();

    public void convertAllToIdeGenerationBulk() {
        List modules = (List)RebelXmlGenerationSource.getIdeExternalGenerationModules().getRight();
        int updated = this.convertToIdeGenerationBlocking(modules, RebelXmlAction.BULK_CONVERT_IDE);
        SharedRebelXmlGeneration.notifyIdeConvertSummary((List)modules, (int)updated);
    }

    int convertToIdeGenerationBlocking(@NotNull List<EclipseIdeProject> modules, RebelXmlAction action) {
        if (modules.isEmpty()) {
            log.info("No modules to convert to external");
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug("Will convert {} modules - {}", (Object)modules.size(), modules);
        }
        for (EclipseIdeProject module : modules) {
            RebelXmlGenerationSource.changePreferencesToIdeGeneration(module);
        }
        RebelXmlGenerationSource.setNoAutoConvert(modules);
        ArrayList<EclipseJob> jobs = new ArrayList<EclipseJob>();
        final AtomicInteger updatedModules = new AtomicInteger(0);
        for (final EclipseIdeProject module : modules) {
            EclipseJob job = new EclipseJob(){

                @Override
                public String getName() {
                    return "Generating rebel.xml for project " + module.getName();
                }

                @Override
                public void run(IProgressMonitor monitor) {
                    try {
                        RebelXmlGenerationTask.createIdeRebelXml(module, true, monitor);
                        SharedRebelXmlGeneration.logConvertedModule((IdeModule)module, (boolean)true);
                        updatedModules.incrementAndGet();
                    }
                    catch (Exception e) {
                        SharedRebelXmlGeneration.logFailedToConvertModule((IdeModule)module, (boolean)true);
                        log.error("Failed to generate rebel.xml for project {}", (Object)module.getName(), (Object)e);
                    }
                }
            };
            jobs.add(job);
        }
        EclipseUtil.runJobsBlocking(jobs, 15);
        this.generator.sendConvertMessage(action, updatedModules.get());
        return updatedModules.get();
    }

    @NotNull
    public static Pair<List<EclipseIdeProject>, List<EclipseIdeProject>> getIdeExternalGenerationModules() {
        List<EclipseIdeProject> modules = ProjectHelper.getJRebelEclipseModules();
        ArrayList<EclipseIdeProject> ideGenerationModules = new ArrayList<EclipseIdeProject>();
        ArrayList<EclipseIdeProject> extGenerationModules = new ArrayList<EclipseIdeProject>();
        for (EclipseIdeProject module : modules) {
            if (module.isIdeRebelXmlGenerationType()) {
                ideGenerationModules.add(module);
                continue;
            }
            extGenerationModules.add(module);
        }
        return Pair.of(ideGenerationModules, extGenerationModules);
    }

    public void convertToExternalGenerationBlockingBulk(@NotNull List<EclipseIdeProject> modules) {
        List<EclipseIdeProject> converted = this.convertToExternalGenerationBlocking(modules, RebelXmlAction.BULK_CONVERT_EXTERNAL);
        RebelXmlGenerationSource.setNoAutoConvert(converted);
        SharedRebelXmlGeneration.notifyExternalConvertSummary(converted, (int)converted.size());
    }

    @NotNull
    List<EclipseIdeProject> convertToExternalGenerationBlockingAutoConvert(@NotNull List<EclipseIdeProject> modules) {
        return this.convertToExternalGenerationBlocking(modules, RebelXmlAction.AUTOCONVERT);
    }

    @NotNull
    private List<EclipseIdeProject> convertToExternalGenerationBlocking(@NotNull List<EclipseIdeProject> modules, RebelXmlAction action) {
        if (log.isDebugEnabled()) {
            log.debug("Will convert {} modules - {}", (Object)modules.size(), modules);
        }
        RebelXmlGenerationSource.printBuildToolUnsupportedWarnings();
        final List<EclipseIdeProject> updated = Collections.synchronizedList(new ArrayList());
        ArrayList<EclipseJob> jobs = new ArrayList<EclipseJob>();
        for (final EclipseIdeProject module : modules) {
            EclipseJob job = new EclipseJob(){

                @Override
                public String getName() {
                    return "Generating rebel.xml for project " + module.getName();
                }

                @Override
                public void run(IProgressMonitor monitor) {
                    try {
                        module.setRebelXmlGenerationType(false);
                        RebelXmlGenerationTask.createBuildToolRebelXml(module, true, true, monitor);
                        updated.add(module);
                        SharedRebelXmlGeneration.logConvertedModule((IdeModule)module, (boolean)false);
                    }
                    catch (Exception e) {
                        RebelXmlGenerationSource.changePreferencesToIdeGeneration(module);
                        module.updateLastExternalCheckFailedTimestamp();
                        SharedRebelXmlGeneration.logFailedToConvertModule((IdeModule)module, (boolean)false);
                        log.error("Failed to generate rebel.xml for project {}", (Object)module.getName(), (Object)e);
                    }
                }
            };
            jobs.add(job);
        }
        EclipseUtil.runJobsBlocking(jobs, 15);
        this.generator.sendConvertMessage(action, updated.size());
        return updated;
    }

    private static void printBuildToolUnsupportedWarnings() {
        for (BuildTool buildTool : ExternalBuildRebelXmlGenerator.unsupportedBuildToolList()) {
            if (BuildTool.MAVEN == buildTool) {
                consolelog.warn("Warning: unable to configure external rebel.xml generation for Maven projects (if any). This requires M2Eclipse plugin to be installed.");
                continue;
            }
            log.warn("Unexpected non-supported buildTool {}", (Object)buildTool);
        }
    }

    public static void setNoAutoConvert(@NotNull EclipseIdeProject module) {
        RebelXmlGenerationSource.setNoAutoConvert(Collections.singletonList(module));
    }
}

