/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.rebelconf;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.actions.ExternalBuildRebelXmlGenerator;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlGenerator;
import org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider;
import org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject;
import org.zeroturnaround.eclipse.nature.RebelXmlBuilder;
import org.zeroturnaround.eclipse.nature.rebelconf.AbstractRebelXmlGeneration;
import org.zeroturnaround.eclipse.nature.rebelconf.BuildToolUnsupportedException;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationMetrics;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationResult;
import org.zeroturnaround.jrebel.client.feature.external.RebelXmlAction;
import org.zeroturnaround.jrebel.client.feature.external.SharedRebelXmlGeneration;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RebelXmlGenerationTask
extends AbstractRebelXmlGeneration {
    private static final Log log = Log.getInstance(RebelXmlGenerationTask.class);
    private static final Log consolelog = ConsoleLog.getInstance(RebelXmlGenerationTask.class);

    static void createIdeRebelXml(EclipseIdeProject module, boolean build, IProgressMonitor monitor) throws Exception {
        IProject eclipseProject = RebelXmlGenerationTask.getEclipseProject(module);
        if (build) {
            eclipseProject.build(10, "org.zeroturnaround.eclipse.rebelXmlBuilder", null, monitor);
        } else {
            RebelXmlGenerator generator = RebelXmlGenerator.forProject(eclipseProject);
            generator.generateIn(RebelXmlGenerationTask.getJRebelProject(module).getXmlGeneratorInput(), false, "GenerateNow button");
        }
    }

    static RebelXmlGenerationResult generateBuildToolRebelXml(EclipseIdeProject module) throws BuildToolUnsupportedException {
        try {
            File tmpFolder = File.createTempFile("eclipse-rebel", "xml");
            if (!tmpFolder.delete()) {
                throw new IllegalStateException("Could not delete " + tmpFolder);
            }
            IRebelXmlGenerator.GenerationResult result = ExternalBuildRebelXmlGenerator.tryToGenerateRebelXmlWithExternalBuildTool(RebelXmlGenerationTask.getEclipseProject(module), tmpFolder);
            if (result.getResult() == IRebelXmlGenerator.ExternalGenerationResult.UNSUPPORTED) {
                if (result.getBuildTool() != null) {
                    throw new BuildToolUnsupportedException(result.getBuildTool());
                }
                throw new IllegalStateException("Unable to generate rebel.xml with external build tool. Project build tool not supported.");
            }
            if (result.getResult() == IRebelXmlGenerator.ExternalGenerationResult.MISSING_PLUGIN) {
                throw new IllegalStateException(String.format("Unable to generate rebel.xml with external build tool. JRebel %s plugin not found for the project.", RebelXmlGenerationTask.getTool(result)));
            }
            if (result.getResult() == IRebelXmlGenerator.ExternalGenerationResult.MISSING_CONF_FILE) {
                throw new IllegalStateException(String.format("Unable to generate rebel.xml with external build tool. Could not find %s conf file for the project.", RebelXmlGenerationTask.getTool(result)));
            }
            if (result.getResult() == IRebelXmlGenerator.ExternalGenerationResult.MISCONFIGURED) {
                throw new IllegalStateException(String.format("Unable to generate rebel.xml with external build tool. JRebel %s plugin failed to generate rebel.xml.", RebelXmlGenerationTask.getTool(result)));
            }
            if (result.getResult() == IRebelXmlGenerator.ExternalGenerationResult.FAILED) {
                throw new IllegalStateException(String.format("Unable to generate rebel.xml with external build tool. JRebel %s plugin failed to generate rebel.xml.", RebelXmlGenerationTask.getTool(result)));
            }
            String content = FileUtils.readFileToString((File)new File(tmpFolder, "rebel.xml"));
            if (StringUtils.isBlank((CharSequence)content)) {
                throw new IllegalStateException("Failed to generate rebel.xml - content empty.");
            }
            return new RebelXmlGenerationResult(content, result.getBuildTool());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not generate rebel.xml with external build tool.", e);
        }
    }

    private static String getTool(IRebelXmlGenerator.GenerationResult result) {
        return result.getBuildTool() != null ? result.getBuildTool().getName() : "";
    }

    public static void buildRebelXml(final EclipseIdeProject module, final Listener listener, final boolean normalBuild, final boolean rebelXmlGenerationTypeChanged) {
        final RebelXmlGenerationMetrics generator = new RebelXmlGenerationMetrics();
        Job job = new Job(String.format("Generating JRebel configuration files for %s.", module.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                boolean isIdeGeneration = module.isIdeRebelXmlGenerationType();
                try {
                    RemotingProject remotingProject;
                    if (isIdeGeneration) {
                        module.clearSavedRebelXml();
                        RebelXmlGenerationTask.createIdeRebelXml(module, normalBuild, monitor);
                    } else {
                        RebelXmlGenerationTask.createBuildToolRebelXml(module, normalBuild, rebelXmlGenerationTypeChanged, monitor);
                    }
                    if (rebelXmlGenerationTypeChanged) {
                        RebelXmlGenerationTask.setNoAutoConvert(Collections.singletonList(module));
                        RebelXmlAction action = isIdeGeneration ? RebelXmlAction.MANUAL_CONVERT_IDE : RebelXmlAction.MANUAL_CONVERT_EXTERNAL;
                        generator.sendConvertMessage(action, 1);
                        SharedRebelXmlGeneration.logConvertedModule((IdeModule)module, (boolean)isIdeGeneration);
                    }
                    listener.onSuccessRebelXml(isIdeGeneration);
                    if (isIdeGeneration && (remotingProject = RebelRemotingProvider.getRemotingProject(module.getEclipseProject())) != null && !remotingProject.isRemotingDisabled()) {
                        new RebelRemotingProvider().generateRemoteXml(module.getEclipseProject(), monitor, true);
                        listener.onSuccessRemoteXml(isIdeGeneration);
                    }
                    listener.onSuccess(isIdeGeneration);
                }
                catch (Exception e) {
                    if (rebelXmlGenerationTypeChanged && !isIdeGeneration) {
                        consolelog.error("Unable to switch project {} to external rebel.xml generation.", (Object)module.getName(), (Object)e);
                    }
                    log.warn("Unable to generate xml", (Throwable)e);
                    if (!isIdeGeneration) {
                        RebelXmlGenerationTask.changePreferencesToIdeGeneration(module);
                        module.updateLastExternalCheckFailedTimestamp();
                    }
                    listener.onException(isIdeGeneration, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    static void createBuildToolRebelXml(EclipseIdeProject module, boolean normalBuild, boolean rebelXmlGenerationTypeChanged, IProgressMonitor monitor) throws BuildToolUnsupportedException, CoreException {
        IFile rebelXml;
        IProject eclipseProject = RebelXmlGenerationTask.getEclipseProject(module);
        if (normalBuild && !rebelXmlGenerationTypeChanged && (rebelXml = new RebelXmlBuilder().getRebelXml(eclipseProject)) != null && rebelXml.exists()) {
            log.debug("Not building rebel.xml as it exists and is not force-build");
            return;
        }
        if (!normalBuild || module.getSavedRebelXmlContent() == null) {
            RebelXmlGenerationResult result = RebelXmlGenerationTask.generateBuildToolRebelXml(module);
            module.setSavedRebelXml(result.getRebelXmlContent(), result.getBuildTool());
        }
        RebelXmlGenerationTask.getJRebelProject(module).deleteRebelXmlWithBackup();
        if (normalBuild) {
            eclipseProject.build(10, "org.zeroturnaround.eclipse.rebelXmlBuilder", null, monitor);
        } else {
            new RebelXmlBuilder().generateExternalRebelXml(eclipseProject, true);
        }
    }

    public static interface Listener {
        public void onSuccessRebelXml(boolean var1);

        public void onSuccessRemoteXml(boolean var1);

        public void onSuccess(boolean var1);

        public void onException(boolean var1, Exception var2);
    }
}

