/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.nature.rebelconf;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlLocator;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RebelXmlLocationCacheUpdateTask {
    private static final Log log = Log.getInstance(RebelXmlLocationCacheUpdateTask.class);

    public static void scheduleRebelXmlLocationCacheUpdateOnStartup() {
        List<EclipseIdeProject> projects = ProjectHelper.getJRebelEclipseModules();
        RebelXmlLocationCacheUpdateTask.scheduleUpdates(projects, false, null);
    }

    public static void updateRebelXmlLocationCacheForProject(EclipseIdeProject module, Callback callback) {
        RebelXmlLocationCacheUpdateTask.scheduleUpdates(Collections.singletonList(module), true, callback);
    }

    private static void scheduleUpdates(final List<EclipseIdeProject> projects, final boolean force, final @Nullable Callback callback) {
        String name = projects.size() == 1 ? String.format("Update JRebel configuration files location for project: %s", projects.get(0).getName()) : String.format("Update JRebel configuration files location for %d projects", projects.size());
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                List<IRebelXmlLocator> hookList = Hooks.getHookList(IRebelXmlLocator.class, "org.zeroturnaround.rebel.xml.location.v3");
                for (EclipseIdeProject module : projects) {
                    for (IRebelXmlLocator locator : hookList) {
                        log.info("Try update cache for module {} with locator {}, force={}", new Object[]{module.getName(), locator, force});
                        locator.updateRebelXmlCache(module, force);
                    }
                    if (callback == null) continue;
                    callback.rebelXmlLocationCacheUpdateFinished(module);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static interface Callback {
        public void rebelXmlLocationCacheUpdateFinished(EclipseIdeProject var1);
    }
}

