/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.notifications;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.notifications.NotificationContent;
import org.zeroturnaround.eclipse.notifications.PopupNotification;
import org.zeroturnaround.eclipse.preferences.JRebelConfigCenterProxy;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.notifications.CommonCommandHandler;
import org.zeroturnaround.jrebel.ide.common.utils.WebLink;

public class DynamicNotification
extends PopupNotification {
    private static final Log log = Log.getInstance(DynamicNotification.class);
    private final String title;
    private final String message;
    private final Level level;
    private final ImageDescriptor image;

    public DynamicNotification(String title, String message, Level level) {
        this(title, message, level, null, 10000L, 8000L);
    }

    public DynamicNotification(NotificationContent content) {
        this(content.title, content.body, content.level);
    }

    public DynamicNotification(String title, String message, Level level, ImageDescriptor image, long displayTimeInMillis, long displayDimmedTimeInMillis) {
        this.title = title != null ? title : "JRebel Notification";
        this.message = message;
        this.level = level;
        this.image = image;
        this.displayTimeInMillis = (int)displayTimeInMillis;
        this.displayDimmedTimeInMillis = (int)displayDimmedTimeInMillis;
        log.trace(" ********* total time " + displayTimeInMillis);
        log.trace(" ********* dimmed time  " + displayDimmedTimeInMillis);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ImageDescriptor getTitleIcon() {
        return this.image;
    }

    @Override
    protected void setBackgroundGradient(GC gc) {
        if (this.level == Level.WARN) {
            gc.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 225));
            gc.setForeground(new Color((Device)Display.getCurrent(), 255, 255, 225));
        } else if (this.level != Level.INFO) {
            gc.setBackground(new Color((Device)Display.getCurrent(), 243, 189, 177));
            gc.setForeground(new Color((Device)Display.getCurrent(), 249, 231, 226));
        } else {
            super.setBackgroundGradient(gc);
        }
    }

    @Override
    protected boolean isSameAs(PopupNotification obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DynamicNotification other = (DynamicNotification)obj;
        return StringUtils.equals((CharSequence)this.title, (CharSequence)other.title) && StringUtils.equals((CharSequence)this.message, (CharSequence)other.message) && this.level.equals((Object)other.level);
    }

    @Override
    public Control createContentArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(1, false);
        container.setLayout((Layout)containerLayout);
        Link messageLink = new Link(container, 0);
        this.inheritColorsFromParent((Control)messageLink);
        messageLink.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        messageLink.setText(this.message);
        messageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicNotification.this.handleSelection(e);
            }
        });
        return container;
    }

    private void handleSelection(SelectionEvent e) {
        if (CommonCommandHandler.handle((String)e.text)) {
            log.debug("Used {} to handle {}", (Object)CommonCommandHandler.class.getSimpleName(), (Object)e.text);
        } else if ("openAdvancedPage".equals(e.text)) {
            JRebelConfigCenterProxy.openConfigCenterAdvancedPage();
        } else if ("#options".equals(e.text)) {
            JRebelConfigCenterProxy.openConfigCenterStartupPage();
        } else if ("openRemotingServersList".equals(e.text)) {
            JRebelConfigCenterProxy.openConfigCenterRemoteServersPage(false);
        } else if ("openRemotingServers".equals(e.text)) {
            JRebelConfigCenterProxy.openConfigCenterRemoteServersPage(true);
        } else if ("openProjectListPage".equals(e.text)) {
            JRebelConfigCenterProxy.openConfigCenterProjectsPage();
        } else if ("openJRebelConsole".equals(e.text)) {
            ConsoleLog.open();
        } else if ("openUpdatePageRelease".equals(e.text)) {
            EclipseUtil.openUpdateWindow();
        } else if ("openUpdatePageNightly".equals(e.text)) {
            BrowserUtil.silentOpenLink((String)"http://update.zeroturnaround.com/update-site/");
        } else if ("openLicenseActivation".equals(e.text) || "openLicenseActivationEnterLicense".equals(e.text)) {
            Event event = null;
            if ("openLicenseActivationEnterLicense".equals(e.text)) {
                event = new Event();
                event.text = "openLicenseActivationEnterLicense";
            }
            EclipseUtil.runCommand("org.zeroturnaround.eclipse.commands.activateJRebelPopup", event);
        } else if ("openSetupGuide".equalsIgnoreCase(e.text)) {
            EclipseUtil.runCommand("org.zeroturnaround.eclipse.commands.openSetupGuide", null);
        } else if ("openSupportDialog".equals(e.text)) {
            EclipseUtil.runCommand("org.zeroturnaround.eclipse.commands.jrebelSupportPopup", null);
        } else {
            BrowserUtil.silentOpenLink((String)WebLink.processTrackingUrl((String)e.text));
        }
        this.close();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("title", (Object)this.title).append("message", (Object)this.message).append("level", (Object)this.level).append("image", (Object)this.image).toString();
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;


        public static Level fromString(String levelStr) {
            if (levelStr == null) {
                return INFO;
            }
            String level = levelStr.toUpperCase(Locale.ENGLISH);
            if (ERROR.name().equals(level)) {
                return ERROR;
            }
            if (WARN.name().equals(level)) {
                return WARN;
            }
            return INFO;
        }
    }
}

