/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.notifications;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.zeroturnaround.eclipse.notifications.DynamicNotification;
import org.zeroturnaround.eclipse.notifications.NotificationManager;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.notifications.Area;
import org.zeroturnaround.jrebel.ide.common.notifications.Level;
import org.zeroturnaround.jrebel.ide.common.notifications.MessageProducer;
import org.zeroturnaround.jrebel.ide.common.notifications.Notification;
import org.zeroturnaround.jrebel.ide.common.notifications.UserNotificationRenderer;
import org.zeroturnaround.jrebel.ide.common.notifications.UserNotifications;
import org.zeroturnaround.jrebel.ide.common.notifications.producers.HtmlMessageProducer;

public class EclipseRenderer
implements UserNotificationRenderer {
    private static final Log log = Log.getInstance(EclipseRenderer.class);
    private static final Pattern PATTERN_HTML_P = Pattern.compile("\\<\\s*p(?:\\s[^\\<]*)?\\>(.*)\\<\\s*\\/\\s*p\\s*\\>", 2);

    public void renderNotification(UserNotifications source, Notification notification) {
        log.trace("renderNotification, source: '{}', notification: {}", (Object)source, (Object)notification);
        DynamicNotification not = null;
        String title = "JRebel";
        String message = "";
        String messageOrig = notification.getMessage(false);
        log.trace(" ********* " + messageOrig.getClass().getName());
        MessageProducer generalProducer = notification.getMessageProducer();
        if (generalProducer instanceof HtmlMessageProducer) {
            log.trace(" ********* is HtmlMessageProducer");
            HtmlMessageProducer producer = (HtmlMessageProducer)generalProducer;
            title = producer.getTitle();
            message = producer.getBody();
            message = this.trimHtmlParagraph(message);
            message = message.replace("<br>", "\n");
            message = message.replace("<br/>", "\n");
            message = message.replace("<br />", "\n");
            for (String removableTag : Arrays.asList("<b>", "</b>")) {
                message = message.replace(removableTag, "");
            }
        } else {
            log.error("Unsupported notification type: {}, renderer: {}", notification.getClass(), (Object)notification.getMessageProducer());
            return;
        }
        log.info("Notification title '{}', body: '{}', level: {}", new Object[]{title, message, notification.getLevel()});
        long dimmedTime = notification.getTimeToShowInMilliseconds() - notification.getTimeToStartFadeoff();
        not = new DynamicNotification(title, message, this.translateLevel(notification.getLevel()), this.translateAreaIcon(notification.getArea()), notification.getTimeToShowInMilliseconds(), dimmedTime);
        NotificationManager.notifyIfNotOpen(not);
    }

    private DynamicNotification.Level translateLevel(Level level) {
        if (level.equals((Object)Level.ERROR)) {
            return DynamicNotification.Level.ERROR;
        }
        if (level.equals((Object)Level.WARNING)) {
            return DynamicNotification.Level.WARN;
        }
        return DynamicNotification.Level.INFO;
    }

    private ImageDescriptor translateAreaIcon(Area area) {
        if (area.equals((Object)Area.REMOTING)) {
            return RebelImage.JREBEL_CLOUD.getDescriptor();
        }
        return RebelImage.JREBEL.getDescriptor();
    }

    private String trimHtmlParagraph(String text) {
        return EclipseRenderer.extractHtmlTagContent(text, text, PATTERN_HTML_P);
    }

    private static String extractHtmlTagContent(String text, String defaultValue, Pattern pattern) {
        String result = defaultValue;
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }
}

