/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.notifications;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.zeroturnaround.common.util.EnvironmentUtil;
import org.zeroturnaround.eclipse.jrebel.PlatformInfo;
import org.zeroturnaround.eclipse.notifications.NotificationManager;
import org.zeroturnaround.eclipse.notifications.PopupNotification;
import org.zeroturnaround.eclipse.notifications.SimpleIconButton;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.preferences.util.LongPreference;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.metrics.NPSSender;
import org.zeroturnaround.jrebel.client.metrics.NPSStartup;
import org.zeroturnaround.jrebel.client.preferences.PreferencesWrapper;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class NPSNotification
extends PopupNotification {
    private static final Log log = Log.getInstance(NPSNotification.class);
    private static final RGB BACKGROUND_GREEN_RGB = new RGB(149, 193, 31);
    private static final RGB DESCRIPTION_GREEN_RGB = new RGB(68, 88, 14);
    private static final RGB SUBMIT_GREEN_RGB = new RGB(48, 63, 10);
    private static final RGB WHITE_RGB = new RGB(255, 255, 255);
    private static final RGB BLACK_RGB = new RGB(0, 0, 0);
    private Color backgroundGreen = this.disposeLater(new Color((Device)Display.getCurrent(), BACKGROUND_GREEN_RGB));
    private Color descriptionGreen = this.disposeLater(new Color((Device)Display.getCurrent(), DESCRIPTION_GREEN_RGB));
    private Color submitGreen = this.disposeLater(new Color((Device)Display.getCurrent(), SUBMIT_GREEN_RGB));
    private Color white = this.disposeLater(new Color((Device)Display.getCurrent(), WHITE_RGB));
    private Color black = this.disposeLater(new Color((Device)Display.getCurrent(), BLACK_RGB));
    private int currentRating = -1;
    private static final PreferencesWrapper prefs = PreferencesWrapper.getInstance();
    private static final LongPreference PREF_LAST_CLOSE_TIME = prefs.getLongPref("ide.nps.last-close-time", 0L);

    private NPSNotification() {
        NPSStartup.onNotificationDisplayed();
        this.sortingWeight = 200;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public int getDisplayTimeInMillis() {
        return 780000;
    }

    @Override
    public int getDisplayDimmedTimeInMillis() {
        return 600000;
    }

    @Override
    public void dispose() {
        NPSStartup.onNotificationClosed();
        super.dispose();
    }

    @Override
    public Control createContentArea(Composite parent) {
        this.createRadioButtonLabels(parent);
        this.createRadioButtons(parent);
        this.createRadioButtonDescriptions(parent);
        Composite buttonsContainer = this.createButtonsContainer(parent);
        this.createSubmitButton(buttonsContainer);
        this.createNeverAgainButton(buttonsContainer);
        return this.createEqualSizeGridContainer(parent, 1, true, true);
    }

    private void createRadioButtonLabels(Composite parent) {
        Composite container = this.createEqualSizeGridContainer(parent, 11, true, false);
        int i = 0;
        while (i <= 10) {
            Composite column = new Composite(container, 0);
            column.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            if (i == 10) {
                layout.marginRight = 2;
            }
            if (EnvironmentUtil.isMac()) {
                layout.marginRight = 3;
            }
            column.setLayout((Layout)layout);
            Label nr = new Label(column, 0);
            nr.setText(String.valueOf(i));
            GridData data = new GridData(0x1000000, 0x1000000, true, false);
            nr.setLayoutData((Object)data);
            SWTUtil.setFontSize((Control)nr, 78);
            ++i;
        }
    }

    private void createRadioButtons(Composite parent) {
        Composite container = this.createEqualSizeGridContainer(parent, 11, true, true);
        int i = 0;
        while (i <= 10) {
            final int rating = i++;
            final Button button = new Button(container, 16);
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!button.getSelection()) {
                        return;
                    }
                    NPSNotification.this.currentRating = rating;
                }
            });
        }
    }

    private void createRadioButtonDescriptions(Composite parent) {
        Composite container = this.createEqualSizeGridContainer(parent, 2, true, false);
        this.createRadioButtonDescriptionLabel(container, "Not likely at all", 16384);
        this.createRadioButtonDescriptionLabel(container, "Very likely", 131072);
    }

    private void createRadioButtonDescriptionLabel(Composite parent, String text, int horizontalAlignment) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(horizontalAlignment, 0x1000000, true, false));
        label.setText(text);
        label.setForeground(this.descriptionGreen);
        SWTUtil.setFontSize((Control)label, 89);
    }

    private Composite createButtonsContainer(Composite parent) {
        Composite buttonsContainer = this.createEqualSizeGridContainer(parent, 2, true, true);
        GridLayout buttonsLayout = (GridLayout)buttonsContainer.getLayout();
        buttonsLayout.marginTop = 5;
        return buttonsContainer;
    }

    private void createSubmitButton(Composite container) {
        NpsButton submit = new NpsButton(container, 0, "Send feedback", true);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1 || NPSNotification.this.currentRating == -1) {
                    return;
                }
                try {
                    NPSNotification.this.onSubmit(NPSNotification.this.currentRating);
                }
                catch (Exception ex) {
                    log.debug("Failed to send NPS score", (Throwable)ex);
                }
                NotificationManager.close(NPSNotification.this);
            }
        };
        this.configureNpsButton(submit, 131072, (MouseListener)listener);
    }

    private void createNeverAgainButton(Composite container) {
        NpsButton submit = new NpsButton(container, 0, "Don't show again", false);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                log.debug("User asked never to see the NPS notification again");
                NPSStartup.getPrefNeverShow().setValue((Object)true);
                NotificationManager.close(NPSNotification.this);
            }
        };
        this.configureNpsButton(submit, 16384, (MouseListener)listener);
    }

    private void configureNpsButton(final NpsButton button, int horizontalAlignment, MouseListener listener) {
        button.setLayoutData(new GridData(horizontalAlignment, 0x1000000, true, false));
        button.setBackground(this.backgroundGreen);
        button.setForeground(this.submitGreen);
        SWTUtil.setFontStyle((Control)button, 1);
        button.setCursor(this.getShell().getDisplay().getSystemCursor(21));
        button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                button.setForeground(NPSNotification.this.black);
            }

            public void mouseExit(MouseEvent e) {
                button.setForeground(NPSNotification.this.submitGreen);
            }
        });
        button.addMouseListener(listener);
    }

    private void onSubmit(int rating) {
        new NPSSender().report(rating, IdeRemoting.getInstance().getConfigurations().getSyncEnabledInstanceServers().size(), "eclipse_" + PlatformInfo.getJRebelPluginNumericVersion());
    }

    @Override
    protected boolean isSameAs(PopupNotification other) {
        return other instanceof NPSNotification;
    }

    @Override
    protected void createTitleArea(Composite parent) {
        Composite container = this.createEqualSizeGridContainer(parent, 3, false, false);
        this.createTitleIcon(container);
        this.createTitleQuestion(container);
        this.createTitleExitButton(container);
    }

    private void createTitleIcon(Composite container) {
        new Label(container, 0).setImage(RebelImage.JREBEL_WHITE.getImage());
    }

    private void createTitleQuestion(Composite container) {
        Label text = new Label(container, 0);
        text.setText("How likely would you be to recommend\nJRebel to a friend or colleague?");
        SWTUtil.setFontStyle((Control)text, 1);
        if (EnvironmentUtil.isLinux()) {
            SWTUtil.setFontSize((Control)text, 85);
        }
        text.setForeground(this.white);
        text.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
    }

    private void createTitleExitButton(Composite container) {
        SimpleIconButton closeIcon = new SimpleIconButton(container, this.getCloseViewImage(), () -> NotificationManager.close(this));
        closeIcon.setLayoutData(new GridData(0x1000000, 128, false, false));
    }

    private Image getCloseViewImage() {
        String name = "IMG_LCL_CLOSE_VIEW_THIN";
        return PlatformUI.getWorkbench().getSharedImages().getImage(name);
    }

    @Override
    protected void setBackgroundGradient(GC gc) {
        gc.setBackground(this.backgroundGreen);
        gc.setForeground(this.backgroundGreen);
    }

    private Composite createEqualSizeGridContainer(Composite parent, int size, boolean equalWidth, boolean removeHeightMargin) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout containerLayout = new GridLayout(size, equalWidth);
        if (removeHeightMargin) {
            containerLayout.marginHeight = 0;
        }
        container.setLayout((Layout)containerLayout);
        return container;
    }

    public static void rescheduleShowing(final long delayMillis) {
        EclipseUtil.runInUiThread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().timerExec((int)delayMillis, () -> NotificationManager.notifyIfNotOpen(new NPSNotification(null)));
            }
        });
    }

    /* synthetic */ NPSNotification(NPSNotification nPSNotification) {
        this();
    }

    private static final class NpsButton
    extends Canvas {
        private static final int MARGIN = 4;
        private final String text;
        private final boolean drawBorder;

        private NpsButton(Composite parent, int style, String text, boolean drawBorder) {
            super(parent, style);
            this.text = text;
            this.drawBorder = drawBorder;
            this.addPaintListener(this::paintControl);
        }

        private void paintControl(PaintEvent e) {
            Point rect = this.getSize();
            e.gc.fillRectangle(0, 0, rect.x, rect.y);
            e.gc.drawText(this.text, 8, 8);
            if (this.drawBorder) {
                e.gc.drawRoundRectangle(4, 4, rect.x - 8 - 1, rect.y - 8 - 1, 4, 4);
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            GC gc = new GC((Drawable)this);
            Point pt = gc.stringExtent(this.text);
            gc.dispose();
            return new Point(pt.x + 16, pt.y + 16);
        }
    }
}

