/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.zeroturnaround.common.util.EnvironmentUtil;
import org.zeroturnaround.eclipse.notifications.PopupNotification;
import org.zeroturnaround.eclipse.ui.FadeUtil;
import org.zeroturnaround.eclipse.ui.NamedShellListener;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

public class NotificationManager {
    private static final Log log = Log.getInstance(NotificationManager.class);
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int MID_ALPHA = 176;
    private static final int FINAL_ALPHA = 225;
    private static final List<Shell> activeShells = new ArrayList<Shell>();
    private static Shell parentShell;
    private static final Comparator<Shell> activeShellComparator;

    static {
        activeShellComparator = new Comparator<Shell>(){

            @Override
            public int compare(Shell o1, Shell o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return PopupNotification.findFromShell(o1).compareTo(PopupNotification.findFromShell(o2));
            }
        };
    }

    public static void close(PopupNotification dialog) {
        dialog.dispose();
        Shell shell = dialog.getShell();
        activeShells.remove(shell);
        shell.dispose();
    }

    public static boolean closeIfOpen(Class<? extends PopupNotification> dialogClass) {
        ArrayList<PopupNotification> toClose = new ArrayList<PopupNotification>();
        for (PopupNotification dialog : NotificationManager.getOpenNotifications()) {
            if (!dialogClass.isAssignableFrom(dialog.getClass())) continue;
            toClose.add(dialog);
        }
        for (PopupNotification dialog : toClose) {
            NotificationManager.close(dialog);
        }
        return !toClose.isEmpty();
    }

    public static void notifyIfNotOpen(PopupNotification dialog) {
        EclipseUtil.runInUiThread(() -> NotificationManager.notifyIfNotOpenInternal(dialog));
    }

    private static List<PopupNotification> getOpenNotifications() {
        ArrayList<Shell> invalidShells = new ArrayList<Shell>();
        ArrayList<PopupNotification> notifications = new ArrayList<PopupNotification>();
        for (Shell shell : activeShells) {
            PopupNotification n = PopupNotification.findFromShell(shell);
            if (n == null) {
                invalidShells.add(shell);
                continue;
            }
            notifications.add(n);
        }
        activeShells.removeAll(invalidShells);
        return notifications;
    }

    private static void notifyIfNotOpenInternal(PopupNotification dialog) {
        for (PopupNotification n : NotificationManager.getOpenNotifications()) {
            if (!n.isSameAs(dialog)) continue;
            return;
        }
        NotificationManager.notifyInternal(dialog);
    }

    private static void positionNotificationsOnMain() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        NotificationManager.positionNotifications(window.getShell());
    }

    private static void positionNotifications(Shell mainShell) {
        NotificationManager.printActiveShells();
        if (!activeShells.isEmpty()) {
            ArrayList<Shell> shells = new ArrayList<Shell>(activeShells);
            Collections.reverse(shells);
            int heightOffset = 0;
            for (Shell shell : shells) {
                Point curLoc = NotificationManager.calcShellPosition(mainShell, shell, heightOffset);
                if (curLoc.y < 0) {
                    activeShells.remove(shell);
                    shell.dispose();
                    continue;
                }
                shell.setLocation(curLoc);
                heightOffset += shell.getSize().y + 0;
            }
        }
    }

    private static Point calcShellPosition(Shell mainShell, Shell shell, int heightOffset) {
        Rectangle clientArea = mainShell.getBounds();
        int startX = clientArea.x + clientArea.width - shell.getSize().x - 2;
        int startY = clientArea.y + clientArea.height - shell.getSize().y - 28;
        startY -= heightOffset;
        startX -= 8;
        startY -= 8;
        if (mainShell.getMaximized() && EnvironmentUtil.isLinux()) {
            startY -= 28;
        }
        return new Point(startX, startY);
    }

    private static synchronized void setParentShell(Shell shell) {
        if (parentShell == null) {
            parentShell = shell;
            parentShell.addListener(11, event -> NotificationManager.positionNotifications(parentShell));
            parentShell.addListener(10, event -> NotificationManager.positionNotifications(parentShell));
        }
    }

    public static void notify(PopupNotification dialog) {
        EclipseUtil.runInUiThread(() -> NotificationManager.notifyInternal(dialog));
    }

    private static void notifyInternal(final PopupNotification dialog) {
        if (!JRebelClientAdapter.getInstance().getClientSettings().isNotificationsEnabled()) {
            return;
        }
        final Shell shell = dialog.createShell();
        final Shell parent = (Shell)(shell.getParent() instanceof Shell ? shell.getParent() : null);
        shell.addListener(12, event -> {
            boolean bl = activeShells.remove(shell);
        });
        if (Display.getDefault().getMonitors().length == 0) {
            return;
        }
        if (parent != null) {
            NotificationManager.setParentShell(parent);
        }
        NotificationManager.addToActiveShell(shell);
        NotificationManager.positionNotificationsOnMain();
        shell.setAlpha(0);
        if (parent != null && parent.getMinimized()) {
            log.debug("parent is minimized. need to add shellListener");
            parent.addShellListener((ShellListener)new NamedShellListener(){

                @Override
                public void shellDeiconified(ShellEvent e) {
                    if (!shell.isDisposed()) {
                        log.debug("setting dialog shell visible");
                        shell.setVisible(true);
                        parent.removeShellListener((ShellListener)this);
                        log.trace("shellListener removed");
                    }
                    super.shellDeiconified(e);
                }
            });
        } else {
            shell.setVisible(true);
        }
        final Runnable closeDialog = new Runnable(){

            @Override
            public void run() {
                NotificationManager.close(dialog);
                NotificationManager.positionNotificationsOnMain();
            }
        };
        if (dialog.getDisplayTimeInMillis() == 0) {
            FadeUtil.fadeIn(shell, 30, 225, 50, () -> {});
        } else if (dialog.getDisplayTimeInMillis() < 13000) {
            FadeUtil.fadeIn(shell, 30, 225, 50, new Runnable(){

                @Override
                public void run() {
                    FadeUtil.startTimerWithMouseOverCheck(shell, dialog.getDisplayTimeInMillis(), new Runnable(){

                        @Override
                        public void run() {
                            FadeUtil.fadeOut(shell, 8, 0, 50, closeDialog);
                        }
                    });
                }
            });
        } else {
            final int fullAlphaDisplayTime = dialog.getDisplayTimeInMillis() - dialog.getDisplayDimmedTimeInMillis();
            final int midAlphaDisplayTime = dialog.getDisplayDimmedTimeInMillis();
            FadeUtil.fadeIn(shell, 30, 225, 50, new Runnable(){

                @Override
                public void run() {
                    FadeUtil.startTimerWithMouseOverCheck(shell, fullAlphaDisplayTime, new Runnable(){

                        @Override
                        public void run() {
                            FadeUtil.fadeOut(shell, 8, 176, 50, new Runnable(){

                                @Override
                                public void run() {
                                    FadeUtil.startTimerWithMouseOverCheck(shell, midAlphaDisplayTime, new Runnable(){

                                        @Override
                                        public void run() {
                                            FadeUtil.fadeOut(shell, 8, 0, 50, closeDialog);
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private static void addToActiveShell(Shell shell) {
        log.trace("addToActiveShell. currently have {} shells ", (Object)activeShells.size());
        NotificationManager.printActiveShells();
        activeShells.add(shell);
        log.trace("after adding one shell {} ", (Object)shell);
        NotificationManager.printActiveShells();
        Collections.sort(activeShells, activeShellComparator);
        log.trace("after sorting");
        NotificationManager.printActiveShells();
    }

    private static void printActiveShells() {
        for (PopupNotification n : NotificationManager.getOpenNotifications()) {
            log.trace("shell dialog: {}", (Object)n);
        }
    }
}

