/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.notifications;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IDisposable;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.notifications.NotificationManager;
import org.zeroturnaround.eclipse.notifications.SimpleIconButton;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class PopupNotification
implements IDisposable,
Comparable<PopupNotification> {
    private static final Log log = Log.getInstance(PopupNotification.class);
    private static final int DEFAULT_SHELL_WIDTH = 350;
    private static final RGB TITLE_FOREGROUND_RGB = new RGB(40, 73, 97);
    private static final RGB BACKGROUND_TOP_GRADIENT_RGB = new RGB(226, 239, 249);
    private static final RGB BACKGROUND_BOTTOM_GRADIENT_RGB = new RGB(177, 211, 243);
    private static final RGB SHELL_BORDER_RGB = new RGB(40, 73, 97);
    private final List<Resource> disposables = new ArrayList<Resource>();
    private Shell shell;
    private Color colourTitleForeground;
    private Color colourTextForeground = this.colourTitleForeground = this.disposeLater(new Color((Device)Display.getCurrent(), TITLE_FOREGROUND_RGB));
    private Color colourTopBackgroundGradient = this.disposeLater(new Color((Device)Display.getCurrent(), BACKGROUND_TOP_GRADIENT_RGB));
    private Color colourBottomBackgroundGradient = this.disposeLater(new Color((Device)Display.getCurrent(), BACKGROUND_BOTTOM_GRADIENT_RGB));
    private Color colourBorder = this.disposeLater(new Color((Device)Display.getCurrent(), SHELL_BORDER_RGB));
    protected Composite inner;
    protected Composite titleArea;
    protected int displayTimeInMillis = 30000;
    protected int displayDimmedTimeInMillis = 8000;
    protected int sortingWeight = 0;

    public abstract String getTitle();

    public ImageDescriptor getTitleIcon() {
        return null;
    }

    protected <T extends Resource> T disposeLater(T res) {
        if (res != null) {
            this.disposables.add(res);
        }
        return res;
    }

    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    public int getDisplayDimmedTimeInMillis() {
        return this.displayDimmedTimeInMillis;
    }

    public int getShellWidth() {
        return 350;
    }

    public abstract Control createContentArea(Composite var1);

    protected void setBackgroundGradient(GC gc) {
        gc.setBackground(this.colourBottomBackgroundGradient);
        gc.setForeground(this.colourTopBackgroundGradient);
    }

    public Shell createShell() {
        Shell parent = null;
        try {
            parent = RebelPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            log.trace("got parent shell: " + parent);
        }
        catch (Exception exception) {}
        this.shell = parent != null ? new Shell(parent, 524296) : new Shell(Display.getDefault(), 540680);
        this.shell.setData((Object)this);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setForeground(this.colourTextForeground);
        this.shell.setBackgroundMode(1);
        this.inner = new Composite((Composite)this.shell, 0);
        this.inheritColorsFromParent((Control)this.inner);
        GridLayout gl = new GridLayout(1, false);
        gl.marginLeft = 5;
        gl.marginTop = 0;
        gl.marginRight = 5;
        gl.marginBottom = 0;
        gl.verticalSpacing = 0;
        this.inner.setLayout((Layout)gl);
        this.createTitleArea(this.inner);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                log.trace("dialog shell resized " + e);
                try {
                    Rectangle rect = PopupNotification.this.shell.getClientArea();
                    Image bgImage = PopupNotification.this.disposeLater(new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height));
                    GC gc = new GC((Drawable)bgImage);
                    PopupNotification.this.setBackgroundGradient(gc);
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                    gc.setAntialias(1);
                    gc.setLineWidth(1);
                    gc.setForeground(PopupNotification.this.colourBorder);
                    gc.drawRoundRectangle(rect.x + 0, rect.y + 0, rect.width - 1, rect.height - 1, 14, 14);
                    gc.dispose();
                    PopupNotification.this.shell.setBackgroundImage(bgImage);
                }
                catch (Exception err) {
                    log.error((Throwable)err);
                }
            }
        });
        Control contentArea = this.createContentArea(this.inner);
        this.setFontStyle(contentArea, false);
        GridData gd = new GridData(1808);
        contentArea.setLayoutData((Object)gd);
        this.shell.setSize(this.shell.computeSize(this.getShellWidth(), -1));
        this.addRoundedCorners(this.shell);
        return this.shell;
    }

    protected void setFontStyle(Control control, boolean bold) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setFontStyle(child, bold);
                ++n2;
            }
            return;
        }
        Font font = control.getFont();
        if (bold) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = font.getFontData();
            int n = fontData.length;
            int n3 = 0;
            while (n3 < n) {
                FontData fd = fontDataArray[n3];
                fd.setStyle(1);
                ++n3;
            }
            Font derived = new Font(font.getDevice(), fontData);
            control.setFont(derived);
            control.addDisposeListener(e -> derived.dispose());
        }
    }

    protected void createTitleArea(Composite parent) {
        this.titleArea = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.titleArea.setLayoutData((Object)gd);
        ImageDescriptor titleIcon = this.getTitleIcon();
        int gridWidth = titleIcon != null ? 3 : 2;
        this.titleArea.setLayout((Layout)new GridLayout(gridWidth, false));
        if (titleIcon != null) {
            Label titleIconLbl = new Label(this.titleArea, 0);
            Image titleImage = this.disposeLater(titleIcon.createImage());
            titleIconLbl.setImage(titleImage);
        }
        Label title = new Label(this.titleArea, 0);
        title.setText(this.getTitle());
        this.setFontStyle((Control)title, true);
        GridData gd2 = new GridData(16384, 0x1000000, true, false);
        gd2.grabExcessHorizontalSpace = true;
        title.setLayoutData((Object)gd2);
        SimpleIconButton closeIcon = new SimpleIconButton(this.titleArea, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_CLOSE_VIEW_THIN"), () -> NotificationManager.close(this));
        GridData closeGd = new GridData(0x1000000, 128, false, false);
        closeIcon.setLayoutData(closeGd);
        this.inheritColorsFromParent((Control)title);
    }

    protected void inheritColorsFromParent(Control control) {
        control.setForeground(null);
        control.setBackground(null);
        control.addPaintListener(paintEvent -> {
            control.setForeground(null);
            control.setBackground(null);
        });
    }

    protected void addRoundedCorners(Shell shell) {
        Region region = this.disposeLater(new Region());
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 5, 1);
        region.subtract(0, 1, 3, 1);
        region.subtract(0, 2, 2, 1);
        region.subtract(0, 3, 1, 1);
        region.subtract(0, 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        region.subtract(0, s.y - 1, 5, 1);
        region.subtract(0, s.y - 2, 3, 1);
        region.subtract(0, s.y - 3, 2, 1);
        region.subtract(0, s.y - 4, 1, 1);
        region.subtract(0, s.y - 5, 1, 1);
        region.subtract(s.x - 5, s.y - 1, 5, 1);
        region.subtract(s.x - 3, s.y - 2, 3, 1);
        region.subtract(s.x - 2, s.y - 3, 2, 1);
        region.subtract(s.x - 1, s.y - 4, 1, 1);
        region.subtract(s.x - 1, s.y - 5, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
    }

    public final void close() {
        NotificationManager.close(this);
    }

    public void dispose() {
        for (Resource disposable : this.disposables) {
            disposable.dispose();
        }
    }

    protected Shell getShell() {
        return this.shell;
    }

    public static PopupNotification findFromShell(Shell shell) {
        Object data = shell.getData();
        if (data instanceof PopupNotification) {
            return (PopupNotification)data;
        }
        return null;
    }

    protected abstract boolean isSameAs(PopupNotification var1);

    @Override
    public int compareTo(PopupNotification o) {
        return this.sortingWeight - o.sortingWeight;
    }
}

