/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.notifications.controllers;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.eclipse.config.ui.newactivation.ActivationDialogNew;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensing;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.TrialRegistrationFormData;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.ui.activation.IActivationPanel;
import org.zeroturnaround.jrebel.ide.common.ui.activation.JRebelActivationDialog;

public class JRebelActivationDialogControllerUtil {
    private static final Log log = Log.getInstance(JRebelActivationDialogControllerUtil.class);
    private final Timer timer = new Timer("rebel.activationDialog", true);

    private JRebelLicensing getLicensing() {
        return Watcher.getInstance().getLicensing();
    }

    protected void runInBackground(Runnable r) {
        this.runInBackground(r, false, null, null);
    }

    protected void runInBackground(final Runnable r, boolean useEclipseJob, String jobName, final String taskName) {
        if (useEclipseJob) {
            Job job = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(taskName, -1);
                    try {
                        r.run();
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(false);
            job.schedule();
        } else {
            this.runInUI(r);
        }
    }

    protected void runInUI(final Runnable r) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Exception e) {
                    log.error("runInUI failed", (Throwable)e);
                }
            }
        }, 0L);
    }

    protected LicensingStatus activateForFile(File theLicenseFile) {
        return this.getLicensing().activateLicenseFile(theLicenseFile);
    }

    protected LicensingStatus activateForPasted(String textForLicense) {
        return this.getLicensing().activateLicenseToken(textForLicense, null);
    }

    protected LicensingStatus activateForLicenseServer(String licenseUrl, String email) {
        log.trace("JRebelActivationDialogController.activateForLicenseServer()");
        licenseUrl = licenseUrl.trim();
        email = email.trim();
        return this.getLicensing().activateLicenseToken(licenseUrl, email);
    }

    protected LicensingStatus activateForFormData(TrialRegistrationFormData fieldsData) {
        log.trace("JRebelActivationDialogController.activateForFormData()");
        return this.getLicensing().registerTrial(fieldsData);
    }

    protected boolean handleActivationResult(LicensingStatus result, IActivationPanel source, JRebelActivationDialog dialog) {
        log.trace("JRebelActivationDialogController.handleActivationResult(JRebelActivationDialog)");
        log.trace(" ********* is valid " + result.isValid());
        dialog.setLicensingStatus(result);
        return result.isValid();
    }

    protected boolean handleActivationResult(LicensingStatus result, Object panel, ActivationDialogNew dialog) {
        log.trace("JRebelActivationDialogController.handleActivationResult(IActivationDialogNew)");
        log.trace(" ********* is valid " + result.isValid());
        dialog.setLicensingStatus(result);
        return result.isValid();
    }
}

