/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.plugins;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.equinox.internal.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitEvent;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.zeroturnaround.eclipse.plugins.InstallableUnitEventWrapper;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class PluginProvisioningListener {
    private static final Log log = Log.getInstance(PluginProvisioningListener.class);
    private final String pluginId;
    private AtomicBoolean isUninstall = new AtomicBoolean(false);
    private AtomicBoolean commitOperationProcessed = new AtomicBoolean(false);
    private AtomicBoolean anyEventReceived = new AtomicBoolean(false);
    private Version oldVersion;
    private Version newVersion;

    protected PluginProvisioningListener(String pluginId) {
        this.pluginId = pluginId;
    }

    protected abstract void onUninstall();

    protected abstract void onUpgrade(Version var1, Version var2);

    public void addToContext(BundleContext context) {
        try {
            ServiceReference[] refs;
            ServiceReference[] serviceReferenceArray = refs = context.getServiceReferences(IProvisioningAgent.class.getName(), "(agent.current=true)");
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                log.debug("found agent without reflection: " + context.getService(ref));
                IProvisioningAgent agent = (IProvisioningAgent)context.getService(ref);
                log.debug("searcing service " + IProvisioningEventBus.SERVICE_NAME);
                IProvisioningEventBus bus = (IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME);
                if (bus != null) {
                    log.debug("found bus: " + bus);
                    ProvisioningListener nListener = this::onProvisionEvent;
                    bus.addListener(nListener);
                    log.debug("added provisioning listener");
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.debug("got exception while setting up provisioning listener. " + e.toString());
        }
    }

    private void onProvisionEvent(EventObject o) {
        if (o instanceof InstallableUnitEvent) {
            InstallableUnitEvent event = (InstallableUnitEvent)o;
            IInstallableUnit installableUnit = event.getInstallableUnit();
            String id = installableUnit.getId();
            Version version = installableUnit.getVersion();
            log.debug("got event {}: {}:{}", new Object[]{InstallableUnitEventWrapper.getEventTypeName(event), id, version});
            if (id.equals(this.pluginId)) {
                this.anyEventReceived.set(true);
                this.isUninstall.set(event.isUninstall());
                if (this.isUninstall.get()) {
                    this.oldVersion = version;
                } else if (event.isInstall()) {
                    this.newVersion = version;
                }
            }
        } else if (o instanceof CommitOperationEvent) {
            if (!this.anyEventReceived.get()) {
                log.trace("Haven't received any events regarding {}, skipping", (Object)this.pluginId);
                return;
            }
            if (!this.commitOperationProcessed.compareAndSet(false, true)) {
                log.trace("Commit operation already processed, skipping. isUninstall: {}", (Object)this.isUninstall);
                return;
            }
            if (this.isUninstall.get()) {
                log.info("running uninstall for {}", (Object)this);
                this.onUninstall();
            } else {
                log.info("running upgrade for {}, old {}, new {}", new Object[]{this, this.oldVersion, this.newVersion});
                if (this.oldVersion == null || this.newVersion == null) {
                    log.warn("One of the versions was null, skipping");
                    return;
                }
                if (this.oldVersion.compareTo((Object)this.newVersion) >= 0) {
                    log.warn("Not running upgrade as new version isn't any newer");
                    return;
                }
                this.onUpgrade(this.oldVersion, this.newVersion);
            }
        }
    }
}

