/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.plugins;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;
import org.zeroturnaround.eclipse.IRebelPluginProvider;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RebelPluginProxy {
    private static final Log log = Log.getInstance(RebelPluginProxy.class);
    private static final String REBEL_PLUGIN_ID = "org.zeroturnaround.eclipse.plugins";

    public List<String> getPluginResources(final IJavaProject project) {
        final ArrayList<String> result = new ArrayList<String>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(REBEL_PLUGIN_ID);
        int i = 0;
        while (i < config.length) {
            IConfigurationElement element = config[i];
            String pluginId = element.getContributor().getName();
            final Bundle bundle = Platform.getBundle((String)pluginId);
            IConfigurationElement[] children = element.getChildren();
            int j = 0;
            while (j < children.length) {
                try {
                    String resource = children[j].getAttribute("resource");
                    if (resource != null) {
                        URL url = bundle.getResource(resource);
                        URL jarURL = FileLocator.toFileURL((URL)url);
                        result.add(jarURL.getFile());
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                ++j;
            }
            if (element.getAttribute("class") != null) {
                try {
                    final Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IRebelPluginProvider) {
                        ISafeRunnable runnable = new ISafeRunnable(){

                            public void handleException(Throwable t) {
                                log.error(t);
                            }

                            public void run() throws Exception {
                                String[] resources = ((IRebelPluginProvider)obj).getPluginResources(project);
                                int k = 0;
                                while (k < resources.length) {
                                    String resource = resources[k];
                                    URL url = bundle.getResource(resource);
                                    URL jarURL = FileLocator.toFileURL((URL)url);
                                    result.add(jarURL.getFile());
                                    ++k;
                                }
                            }
                        };
                        SafeRunner.run((ISafeRunnable)runnable);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean hasPlugins() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(REBEL_PLUGIN_ID).length > 0;
    }
}

