/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.jrebel.client.logger.Log;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final Log log = Log.getInstance(PreferenceInitializer.class);
    private static final int PREFS_VERSION_INITIAL = 0;
    private static final int PREFS_VERSION_POST_REMOTING_PLUGIN_MIGRATE = 1;
    private static final int PREFS_VERSION_LEGACY_DELETION = 2;

    public void initializeDefaultPreferences() {
        IPreferenceStore store = RebelPlugin.getDefault().getPreferenceStore();
        store.setDefault("jrebelBeta6", true);
        store.setDefault("jrebelPreLaunchCheck", true);
        store.setDefault("jrebelAutoNature", true);
        store.setDefault("jrebelActivateUseProxy", true);
        store.setDefault("jrebelRunViaIdeRadio", 0);
        store.setDefault("enableDebuggerLogging", false);
        store.setDefault("jrebel.remoting.debugOutput", false);
        store.setDefault("jrebel.remoting.showOnOutput", false);
        store.setDefault("jrebel.remoting.showOnError", false);
        store.setDefault("jrebel.remoting.showSyncSucceededNotification", true);
        store.setDefault("jrebel.remoting.syncOnBuildGlobal", true);
        store.setDefault("preference.store.version", 0);
        this.doMigrations();
    }

    private void doMigrations() {
        this.migrate(this::pluginMergeTask, 1);
        this.migrate(this::legacyBurialTask, 2);
    }

    private void migrate(MigrateTask migrateTask, int version) {
        IPreferenceStore store = RebelPlugin.getDefault().getPreferenceStore();
        if (store.getInt("preference.store.version") < version) {
            log.debug("Preferences have already been migrated (tried version={})", (Object)version);
            return;
        }
        log.debug("Starting running migration {} as the prefs version is {}", (Object)version, (Object)store.getInt("preference.store.version"));
        try {
            migrateTask.runTask(store);
        }
        finally {
            store.setValue("preference.store.version", version);
        }
    }

    private void pluginMergeTask(IPreferenceStore store) {
        String prefName;
        String[] prefsToMigrate;
        ScopedPreferenceStore oldStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.zeroturnaround.eclipse.remoting");
        String[] stringArray = prefsToMigrate = new String[]{"jrebel.remoting.debugOutput", "jrebel.remoting.showOnOutput", "jrebel.remoting.showOnError", "jrebel.remoting.showSyncSucceededNotification", "jrebel.remoting.syncOnBuildGlobal"};
        int n = prefsToMigrate.length;
        int n2 = 0;
        while (n2 < n) {
            prefName = stringArray[n2];
            if (oldStore.contains(prefName)) {
                boolean value = oldStore.getBoolean(prefName);
                log.debug("Migrating key {} with value {} to new preferenceStore", (Object)prefName, (Object)value);
                store.setValue(prefName, value);
            }
            ++n2;
        }
        stringArray = prefsToMigrate;
        n = prefsToMigrate.length;
        n2 = 0;
        while (n2 < n) {
            prefName = stringArray[n2];
            log.debug("New store values: {} : {}", (Object)prefName, (Object)store.getBoolean(prefName));
            ++n2;
        }
    }

    private void legacyBurialTask(IPreferenceStore store) {
        if (store.getBoolean("jrebelEmbedded")) {
            store.setValue("jrebelBeta6", true);
        }
    }

    private static interface MigrateTask {
        public void runTask(IPreferenceStore var1);
    }
}

