/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.projectpath;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.zeroturnaround.eclipse.jrebel.ProjectsPathProvider;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.startup.SharedScheduler;

public class EclipseProjectPathListener {
    private static final Log log = Log.getInstance(EclipseProjectPathListener.class);
    private final IResourceChangeListener resourceChangeListener = this.createResourceChangeListener();
    private final ProjectsPathProvider projectsPathProvider = new ProjectsPathProvider();

    public void startListener() {
        EclipseUtil.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        SharedScheduler.getExecutor().schedule(this::triggerForExistingProjects, 10L, TimeUnit.SECONDS);
    }

    private void triggerForExistingProjects() {
        Map<String, File> projectPathsMap = this.projectsPathProvider.getProjects();
        for (String projectId : projectPathsMap.keySet()) {
            JRebelConfiguration.getDefault().addProjectPathVariable(projectId, projectPathsMap.get(projectId));
        }
    }

    private IResourceChangeListener createResourceChangeListener() {
        return event -> {
            if (event.getType() == 1) {
                try {
                    event.getDelta().accept(delta -> {
                        int type = delta.getResource().getType();
                        if (type == 8) {
                            return true;
                        }
                        if (this.projectAdded(delta) || this.projectOpened(delta)) {
                            Map<String, File> projectPathsMap = this.projectsPathProvider.getForSingleProject(delta.getResource().getProject());
                            for (String projectId : projectPathsMap.keySet()) {
                                JRebelConfiguration.getDefault().addProjectPathVariable(projectId, projectPathsMap.get(projectId));
                            }
                        }
                        return false;
                    });
                }
                catch (CoreException e) {
                    log.warn((Throwable)e);
                }
            }
        };
    }

    private boolean projectAdded(IResourceDelta delta) {
        IResource resource = delta.getResource();
        return resource.getType() == 4 && delta.getKind() == 1;
    }

    private boolean projectOpened(IResourceDelta delta) {
        IResource resource = delta.getResource();
        return resource.getType() == 4 && delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && resource.getProject().isOpen();
    }
}

