/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.properties;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.eclipse.config.ui.widgets.JRebelConfigurationGrid;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedButton;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedIcon;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextLabel;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class ExplicitRemoteServersSelectionPanel {
    private ExplicitRemoteServersList serversPanel;

    public ExplicitRemoteServersSelectionPanel(Composite parent, BaseRemoteModule remotingClientProject) {
        boolean hasRemoteServers = !IdeRemoting.getInstance().getConfigurations().getInstanceServers().isEmpty();
        this.serversPanel = hasRemoteServers ? new ExplicitRemoteServersListHasServers(parent, remotingClientProject) : new ExplicitRemoteServersListNoServers(parent);
    }

    public List<RemoteServerConfiguration> getSelectedServers() {
        return this.serversPanel.getSelectedServers();
    }

    public void showNoServersSelectedWarning(boolean visible) {
        this.serversPanel.showNoServersSelectedWarning(visible);
    }

    private static Label createErrorLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setForeground(Display.getCurrent().getSystemColor(3));
        return label;
    }

    private static interface ExplicitRemoteServersList {
        public List<RemoteServerConfiguration> getSelectedServers();

        public void showNoServersSelectedWarning(boolean var1);
    }

    private static class ExplicitRemoteServersListHasServers
    implements ExplicitRemoteServersList {
        private final Label errorLabel;
        private final ExplicitRemoteServersSelectionGrid grid;

        private ExplicitRemoteServersListHasServers(Composite parent, BaseRemoteModule remotingClientProject) {
            Composite composite = this.createGridComposite(parent);
            Composite errorArea = this.createGridComposite(composite);
            ((GridLayout)errorArea.getLayout()).marginBottom = 2;
            this.errorLabel = ExplicitRemoteServersSelectionPanel.createErrorLabel(errorArea, "At least one server has to be selected.");
            this.errorLabel.setVisible(false);
            SelectionAdapter selectionListener = this.createSelectionListener();
            this.grid = new ExplicitRemoteServersSelectionGrid(composite, remotingClientProject, (SelectionListener)selectionListener);
        }

        private SelectionAdapter createSelectionListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        this.showNoServersSelectedWarning(false);
                    }
                }
            };
        }

        private Composite createGridComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            return composite;
        }

        @Override
        public void showNoServersSelectedWarning(boolean visible) {
            if (this.errorLabel.isVisible() != visible) {
                this.errorLabel.setVisible(visible);
            }
        }

        @Override
        public List<RemoteServerConfiguration> getSelectedServers() {
            return this.grid.getSelectedServers();
        }
    }

    private static class ExplicitRemoteServersListNoServers
    implements ExplicitRemoteServersList {
        private final Label errorLabel;

        private ExplicitRemoteServersListNoServers(Composite parent) {
            new Label(parent, 0);
            String message = "You have no JRebel remote servers configured. Add servers via\nHelp > JRebel > Configuration > Remote servers.";
            Label label = new Label(parent, 0);
            label.setText(message);
            SWTUtil.setFontStyle((Control)label, 2);
            new Label(parent, 0);
            this.errorLabel = ExplicitRemoteServersSelectionPanel.createErrorLabel(parent, "You need to configure a remote server first.");
            this.errorLabel.setVisible(false);
        }

        @Override
        public List<RemoteServerConfiguration> getSelectedServers() {
            return Collections.emptyList();
        }

        @Override
        public void showNoServersSelectedWarning(boolean visible) {
            if (this.errorLabel.getVisible() != visible) {
                this.errorLabel.setVisible(visible);
            }
        }
    }

    private static class ExplicitRemoteServersSelectionGrid
    extends JRebelConfigurationGrid {
        private final List<Row> rows = new ArrayList<Row>();

        private ExplicitRemoteServersSelectionGrid(Composite parent, BaseRemoteModule remotingProject, SelectionListener selectionListener) {
            super(parent, 2);
            new SpacedIcon(this.container, RebelImage.JREBEL_CLOUD.getImage(), 22, null);
            new SpacedTextLabel(this.container, 22).setText("Server");
            IdeModule module = remotingProject.getIdeModule();
            List servers = IdeRemoting.getInstance().getConfigurations().getExplicitServersListForUI(module);
            for (Pair serverSelectionPair : servers) {
                SpacedButton syncEnabledCheckbox = new SpacedButton(this.container, 32, null);
                syncEnabledCheckbox.setSelection((Boolean)serverSelectionPair.getRight());
                syncEnabledCheckbox.addSelectionListener(selectionListener);
                new SpacedTextLabel(this.container, 22).setText(((RemoteServerConfiguration)serverSelectionPair.getLeft()).getNameOrUrl());
                this.rows.add(new Row(syncEnabledCheckbox, (RemoteServerConfiguration)serverSelectionPair.getLeft()));
            }
        }

        private List<RemoteServerConfiguration> getSelectedServers() {
            ArrayList<RemoteServerConfiguration> result = new ArrayList<RemoteServerConfiguration>();
            for (Row row : this.rows) {
                if (!row.button.getSelection()) continue;
                result.add(row.server);
            }
            return result;
        }

        private static class Row {
            final SpacedButton button;
            final RemoteServerConfiguration server;

            Row(SpacedButton button, RemoteServerConfiguration server) {
                this.button = button;
                this.server = server;
            }
        }
    }
}

