/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.actions.OpenRebelXmlAction;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.rebelconf.BuildToolUnsupportedException;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationSource;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationTask;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlLocationCacheUpdateTask;
import org.zeroturnaround.eclipse.properties.AbstractJRebelPropertiesPage;
import org.zeroturnaround.eclipse.properties.ExternalGenerationFailedDialog;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JRebelPropertiesPage
extends AbstractJRebelPropertiesPage {
    public static final String PAGE_ID = "org.zeroturnaround.eclipse.properties.jrebelPropertiesPage";
    private static final Log log = Log.getInstance(JRebelPropertiesPage.class);
    private static final Log consolelog = ConsoleLog.getInstance(JRebelPropertiesPage.class);
    private Button useRelativePaths;
    private Button customXmlDirectoryEnabled;
    private Text customDirectoryPath;
    private Label customDirectoryError;
    private Button ideGenerationButton;
    private Button externalGenerationButton;
    private Label generationError;
    private Button generateButton;

    protected Control createContents(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(4, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        FormToolkit toolkit = this.createToolkit(group);
        try {
            Label title = new Label(group, 0);
            title.setText("Generation of JRebel configuration files");
            title.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
            SWTUtil.setFontStyle((Control)title, 1);
            Label separator = new Label(group, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
            this.addDescriptionLabels(group);
            this.addBreakLabel(group);
            this.addIdeExternalButtons(group);
            this.addBreakLabel(group);
            this.addCustomXmlDirectoryBlock(toolkit, group);
            this.addRegenerateAndOpenRebelXMLButtonSection(group);
            this.onGenerationButtonChange();
        }
        catch (Exception e) {
            log.error("Unable to create property page", (Throwable)e);
        }
        return group;
    }

    private void addRegenerateAndOpenRebelXMLButtonSection(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayout((Layout)new RowLayout());
        outer.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.addGenerateButton(outer);
        this.addOpenXmlButton(outer);
    }

    private FormToolkit createToolkit(Composite composite) {
        FormToolkit toolkit = new FormToolkit(composite.getDisplay());
        composite.addDisposeListener(e -> toolkit.dispose());
        toolkit.setBackground(composite.getBackground());
        toolkit.adapt(composite);
        toolkit.paintBordersFor(composite);
        return toolkit;
    }

    private void addDescriptionLabels(Composite parent) {
        new ZtLabel(parent).bold("rebel.xml").text("is a mappings file that defines workspace resources that JRebel will monitor and reload.").newline().bold("rebel-remote.xml").text("is a marker file that helps to identify projects on the remote server.");
    }

    private void addIdeExternalButtons(Composite parent) {
        this.ideGenerationButton = new Button(parent, 16);
        this.ideGenerationButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.ideGenerationButton.setText("Generate rebel.xml by IDE plugin (recommended)");
        boolean isIdeGeneration = this.getIdeModule().isIdeRebelXmlGenerationType();
        this.ideGenerationButton.setSelection(isIdeGeneration);
        this.createRelativePathsButton(parent);
        this.externalGenerationButton = new Button(parent, 16);
        this.externalGenerationButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.externalGenerationButton.setText("Generate rebel.xml by external build tool");
        this.externalGenerationButton.setSelection(!isIdeGeneration);
        this.generationError = new Label(parent, 0);
        this.generationError.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    JRebelPropertiesPage.this.onGenerationButtonChange();
                }
            }
        };
        this.ideGenerationButton.addSelectionListener((SelectionListener)radioListener);
        this.externalGenerationButton.addSelectionListener((SelectionListener)radioListener);
    }

    private void onGenerationButtonChange() {
        boolean enabled = this.ideGenerationButton.getSelection();
        this.useRelativePaths.setEnabled(enabled);
    }

    private void createRelativePathsButton(Composite parent) {
        this.useRelativePaths = new Button(parent, 32);
        GridData layoutData = new GridData(16384, 0x1000000, false, false, 4, 1);
        layoutData.horizontalIndent = 20;
        this.useRelativePaths.setLayoutData((Object)layoutData);
        this.useRelativePaths.setText("Use relative paths in rebel.xml");
        this.useRelativePaths.setSelection(((Boolean)this.getJRebelProject().useRelativePaths().get(this.getProject())).booleanValue());
    }

    private void addCustomXmlDirectoryBlock(FormToolkit toolkit, Composite parent) {
        new ZtLabel(parent).text("Default configuration file location: ").bold(this.getRelativeDefaultXmlDirectory());
        this.customXmlDirectoryEnabled = this.addCustomXmlDirectoryEnabledButton(parent);
        this.addCustomDirectoryLabel(parent);
        this.customDirectoryPath = this.addCustomXmlDirectoryText(parent);
        ImageHyperlink lnkOpenDir = this.addDirectoryChooserLink(toolkit, parent);
        Hyperlink lnkResetDir = this.addDirectoryResetLink(toolkit, parent);
        this.customDirectoryError = this.addCustomDirectoryErrorLabel(parent);
        List<Control> controls = Arrays.asList(this.customDirectoryPath, lnkOpenDir, lnkResetDir, this.customDirectoryError);
        this.addCustomDirectoryEnabledListener(this.customXmlDirectoryEnabled, controls);
    }

    private Label addCustomDirectoryErrorLabel(Composite parent) {
        Label labelCustomDirectoryError = new Label(parent, 0);
        labelCustomDirectoryError.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        labelCustomDirectoryError.setForeground(Display.getCurrent().getSystemColor(3));
        return labelCustomDirectoryError;
    }

    private Button addCustomXmlDirectoryEnabledButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        button.setText("Override configuration file location (relative to project root):");
        button.setToolTipText("Override only when rebel.xml/rebel-remote.xml are not copied to JAR/WAR from the default location.");
        button.setSelection(this.hasCustomRebelXmlDirectory());
        return button;
    }

    private void addCustomDirectoryLabel(Composite parent) {
        Label labelCustomDirectory = new Label(parent, 0);
        labelCustomDirectory.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        labelCustomDirectory.setText("Select a project folder from where the configuration files will be copied into JAR/WAR upon build.");
    }

    private Text addCustomXmlDirectoryText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        text.setText(this.getCustomXmlDirectoryPathOrDefault());
        text.addModifyListener(e -> this.customDirectoryError.setText(""));
        return text;
    }

    private ImageHyperlink addDirectoryChooserLink(FormToolkit toolkit, Composite parent) {
        ImageHyperlink link = toolkit.createImageHyperlink(parent, 4);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        link.setImage(RebelImage.EXPLORE_FOLDER.getImage());
        link.setText("Explore");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JRebelPropertiesPage.this.browseForDirectory();
            }
        });
        return link;
    }

    private Hyperlink addDirectoryResetLink(FormToolkit toolkit, Composite parent) {
        Hyperlink link = toolkit.createHyperlink(parent, null, 4);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        link.setText("Restore default");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JRebelPropertiesPage.this.customDirectoryPath.setText(JRebelPropertiesPage.this.getRelativeDefaultXmlDirectory());
            }
        });
        return link;
    }

    private void addCustomDirectoryEnabledListener(final Button enableButton, final List<Control> controls) {
        final Runnable pathEnabledListener = new Runnable(){

            @Override
            public void run() {
                boolean selected = enableButton.getSelection();
                for (Control ctr : controls) {
                    if (ctr == JRebelPropertiesPage.this.customDirectoryError) continue;
                    ctr.setEnabled(selected);
                }
                if (!selected) {
                    JRebelPropertiesPage.this.customDirectoryError.setText("");
                }
            }
        };
        pathEnabledListener.run();
        enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pathEnabledListener.run();
            }
        });
    }

    private void addGenerateButton(Composite parent) {
        this.generateButton = new Button(parent, 0);
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelPropertiesPage.this.generateRebelXml();
            }
        });
        this.generateButton.setText("Regenerate XML configuration");
        this.generateButton.setToolTipText("Regenerate rebel.xml and rebel-remote.xml. Resets to default settings.");
    }

    private void addOpenXmlButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelPropertiesPage.this.showRebelXmlContent();
            }
        });
        button.setText("Open rebel.xml");
    }

    private void addBreakLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
    }

    private void showRebelXmlContent() {
        OpenRebelXmlAction.openRebelXml(this.getProject());
    }

    private boolean validateCustomDirectory() {
        if (!this.customXmlDirectoryEnabled.getSelection()) {
            return true;
        }
        if (this.customDirectoryHasNotChanged()) {
            return true;
        }
        String message = this.getCustomDirectoryError();
        this.customDirectoryError.setText(message);
        return StringUtils.isBlank((CharSequence)message);
    }

    private boolean customDirectoryHasNotChanged() {
        return this.customDirectoryPath.getText().equals(this.getCustomXmlDirectoryPath(this.customXmlDirectoryEnabled.getSelection()));
    }

    private String getCustomDirectoryError() {
        IContainer path;
        try {
            path = this.getCustomDirectoryPath();
        }
        catch (Exception e) {
            log.info("Invalid custom path: {}", (Object)this.customDirectoryPath.getText(), (Object)e);
            return "Please specify path relative to project root.";
        }
        if (!path.exists()) {
            return "Specified folder does not exist!";
        }
        if (path.getType() != 2 && path.getType() != 4) {
            return "Specified path does not point to directory!";
        }
        if (this.getProjectOutputFolders(this.getProject()).contains(path)) {
            return "Cleaned folders should not be used for JRebel configuration files.";
        }
        return "";
    }

    private IContainer getCustomDirectoryPath() {
        String path = this.customDirectoryPath.getText();
        if (path.isEmpty()) {
            return this.getProject();
        }
        return this.getProject().getFolder(path);
    }

    private void browseForDirectory() {
        IProject project = this.getProject();
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        IResource initial = root.findMember(project.getFullPath().append(this.customDirectoryPath.getText()));
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Choose rebel.xml generation folder");
        dialog.setInput((Object)root);
        dialog.setInitialSelection((Object)initial);
        dialog.addFilter(this.createFilter());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IContainer result = (IContainer)dialog.getFirstResult();
            String selectedPath = result.getProjectRelativePath().toPortableString();
            this.customDirectoryPath.setText(selectedPath);
        }
    }

    private ViewerFilter createFilter() {
        IProject project = this.getProject();
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        HashSet<IProject> rejectedElements = new HashSet<IProject>(Arrays.asList(root.getProjects()));
        rejectedElements.remove(project);
        rejectedElements.addAll(this.getProjectOutputFolders(project));
        Class[] acceptedTypes = new Class[]{IProject.class, IFolder.class};
        return new TypedViewerFilter(acceptedTypes, rejectedElements.toArray());
    }

    private Set<IContainer> getProjectOutputFolders(IProject project) {
        LinkedHashSet<IContainer> outFolders = new LinkedHashSet<IContainer>();
        IJavaProject javaProject = this.getJavaProject(project);
        if (javaProject != null) {
            try {
                IClasspathEntry[] classpath;
                outFolders.add(this.getOutputContainer(project, javaProject.getOutputLocation()));
                IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
                int n = classpath.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cp = iClasspathEntryArray[n2];
                    outFolders.add(this.getOutputContainer(project, cp.getOutputLocation()));
                    ++n2;
                }
            }
            catch (CoreException e) {
                log.warn((Throwable)e);
            }
        }
        for (String folder : ProjectHelper.DEFAULT_OUT_FOLDERS) {
            outFolders.add((IContainer)project.getFolder(folder));
        }
        outFolders.remove(null);
        return outFolders;
    }

    public IContainer getOutputContainer(IProject project, IPath outputLocation) {
        if (outputLocation == null) {
            return null;
        }
        return (IContainer)project.getWorkspace().getRoot().findMember(outputLocation);
    }

    private boolean hasCustomRebelXmlDirectory() {
        JRebelProject project = this.getJRebelProject();
        return (Boolean)project.hasCustomXmlDirectory().get(project.getProject());
    }

    private String getCustomXmlDirectoryPathOrDefault() {
        String path = this.getSavedCustomRebelXmlDirectory();
        return path == null ? this.getRelativeDefaultXmlDirectory() : path;
    }

    private String getCustomXmlDirectoryPath(boolean customXmlDirectoryEnabled) {
        String path = this.getSavedCustomRebelXmlDirectory();
        if (customXmlDirectoryEnabled && path != null) {
            return path;
        }
        return this.getRelativeDefaultXmlDirectory();
    }

    private String getSavedCustomRebelXmlDirectory() {
        return (String)this.getJRebelProject().customXmlDirectoryPath().get(this.getProject());
    }

    private String getRelativeDefaultXmlDirectory() {
        return this.getDefaultXmlDirectory().getProjectRelativePath().toPortableString();
    }

    private void generateRebelXml() {
        log.info("clicked on GenerateNow button");
        boolean rebelXmlGenerationTypeChanged = this.isRebelXmlGenerationTypeChanged();
        if (!this.saveWithBuild(false)) {
            return;
        }
        EclipseIdeProject module = this.getIdeModule();
        consolelog.info("Generating XML configuration for project {}...", (Object)module.getName());
        this.updateGenerateRebelXmlUI("Generating XML configuration files ...", 9, false);
        Runnable builRebelXml = () -> {
            Display.getDefault().syncExec(this::moveExistingFilesWithoutCheck);
            RebelXmlGenerationTask.buildRebelXml(module, this.createRebelXmlGenerationListener(module.getName()), false, rebelXmlGenerationTypeChanged);
        };
        if (this.hasCustomRebelXmlDirectory()) {
            builRebelXml.run();
        } else {
            RebelXmlLocationCacheUpdateTask.updateRebelXmlLocationCacheForProject(module, it -> {
                this.removeExistingRebelXml();
                this.runInUiThreadIfNotDisposed(() -> this.customDirectoryPath.setText(this.getCustomXmlDirectoryPath(false)));
                builRebelXml.run();
            });
        }
    }

    private void removeExistingRebelXml() {
        IFile file;
        while ((file = ProjectHelper.getRebelXml(this.getProject())) != null) {
            try {
                log.info("Removing existing rebel.xml: {}", (Object)file);
                file.delete(true, false, null);
            }
            catch (CoreException e) {
                log.warn("Unable to delete: {}", (Object)file, (Object)e);
                break;
            }
        }
    }

    private RebelXmlGenerationTask.Listener createRebelXmlGenerationListener(final String moduleName) {
        return new RebelXmlGenerationTask.Listener(){
            boolean isRemoteGenerated = false;

            @Override
            public void onSuccessRebelXml(boolean isIdeGeneration) {
                consolelog.info("rebel.xml for project {} successfully generated.", (Object)moduleName);
            }

            @Override
            public void onSuccessRemoteXml(boolean isIdeGeneration) {
                consolelog.info("rebel-remote.xml for project {} successfully generated.", (Object)moduleName);
                this.isRemoteGenerated = true;
            }

            @Override
            public void onSuccess(boolean isIdeGeneration) {
                JRebelPropertiesPage.this.runInUiThreadIfNotDisposed(() -> {
                    String message = this.isRemoteGenerated ? "Successfully generated rebel.xml and rebel-remote.xml." : "Successfully regenerated rebel.xml.";
                    JRebelPropertiesPage.this.updateGenerateRebelXmlUI(message, 9, true);
                });
            }

            @Override
            public void onException(boolean isIdeGeneration, Exception e) {
                if (e instanceof BuildToolUnsupportedException) {
                    consolelog.error(((BuildToolUnsupportedException)e).getConsoleMessage());
                } else {
                    consolelog.error("Configuration XML generation failed for project {}. {}", (Object)moduleName, (Object)e.getMessage());
                }
                JRebelPropertiesPage.this.runInUiThreadIfNotDisposed(() -> JRebelPropertiesPage.this.updateGenerateRebelXmlUI(StringUtils.defaultString((String)e.getMessage(), (String)"Generate failed"), 3, true));
                if (!isIdeGeneration) {
                    JRebelPropertiesPage.this.revertExternalGenerationSetting();
                    JRebelPropertiesPage.this.showExternalGenerationErrorDialogIfViewDisposed();
                }
            }
        };
    }

    private void updateGenerateRebelXmlUI(String s, int color, boolean enabled) {
        this.generationError.setText(s);
        this.generationError.setForeground(Display.getCurrent().getSystemColor(color));
        this.generateButton.setEnabled(enabled);
    }

    private void runInUiThreadIfNotDisposed(@NotNull Runnable runnable) {
        if (!this.isDisposed()) {
            EclipseUtil.runInUiThread(() -> {
                if (!this.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    private boolean isDisposed() {
        return this.getControl().isDisposed();
    }

    private IContainer getDefaultXmlDirectory() {
        try {
            RebelXmlGenerator generator = RebelXmlGenerator.forProject(this.getProject());
            return generator.findBestSourceFolderForRebelXml();
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to find default directory: " + this.getProject().getName(), e);
        }
    }

    private IJavaProject getJavaProject(IProject project) {
        return EclipseUtil.getJavaProject(project);
    }

    protected void performDefaults() {
        this.restoreDefaultPreferences();
        super.performDefaults();
    }

    private void restoreDefaultPreferences() {
        JRebelProject jrProject = this.getJRebelProject();
        this.useRelativePaths.setSelection(((Boolean)jrProject.useRelativePaths().getDefaultValue()).booleanValue());
        this.customXmlDirectoryEnabled.setSelection(((Boolean)jrProject.hasCustomXmlDirectory().getDefaultValue()).booleanValue());
        this.customXmlDirectoryEnabled.notifyListeners(13, new Event());
        this.customDirectoryPath.setText(this.getRelativeDefaultXmlDirectory());
        if (this.ideGenerationButton != null) {
            this.ideGenerationButton.setSelection(true);
        }
        if (this.externalGenerationButton != null) {
            this.externalGenerationButton.setSelection(false);
        }
        this.setMessage(null, 0);
        this.generationError.setText("");
    }

    public boolean performOk() {
        return this.saveWithBuild(true);
    }

    private boolean saveWithBuild(boolean doBuild) {
        if (!this.validateCustomDirectory()) {
            return false;
        }
        try {
            this.moveExistingFiles();
            boolean rebelXmlGenerationTypeChanged = this.isRebelXmlGenerationTypeChanged();
            this.saveProperties();
            if (doBuild) {
                this.buildRebelXml(rebelXmlGenerationTypeChanged);
            }
            this.setMessage(null, 0);
        }
        catch (Exception e) {
            log.warn("Settings apply failed", (Throwable)e);
            this.setMessage(StringUtils.defaultString((String)e.getMessage(), (String)"Settings failed"), 3);
            return false;
        }
        return true;
    }

    private boolean isRebelXmlGenerationTypeChanged() {
        EclipseIdeProject module = this.getIdeModule();
        boolean newIdeGenerationSelection = this.ideGenerationButton.getSelection();
        return module.isIdeRebelXmlGenerationType() ^ newIdeGenerationSelection;
    }

    private void buildRebelXml(boolean rebelXmlGenerationTypeChanged) {
        EclipseIdeProject module = this.getIdeModule();
        RebelXmlGenerationTask.Listener listener = this.createRebelXmlGenerationListener(module.getName());
        RebelXmlGenerationTask.buildRebelXml(module, listener, true, rebelXmlGenerationTypeChanged);
    }

    private void revertExternalGenerationSetting() {
        log.warn("Will revert to IDE generation due to exception");
        this.runInUiThreadIfNotDisposed(() -> {
            this.ideGenerationButton.setSelection(true);
            this.externalGenerationButton.setSelection(false);
        });
    }

    private void showExternalGenerationErrorDialogIfViewDisposed() {
        EclipseUtil.runInUiThread(() -> {
            if (this.isDisposed()) {
                ExternalGenerationFailedDialog.show(Display.getCurrent().getActiveShell(), this.getIdeModule().getName());
            }
        });
    }

    private void moveExistingFiles() {
        if (this.hasCustomRebelXmlDirectory() == this.customXmlDirectoryEnabled.getSelection() && this.customDirectoryHasNotChanged()) {
            return;
        }
        this.moveExistingFilesWithoutCheck();
    }

    private void moveExistingFilesWithoutCheck() {
        JRebelProject project = this.getJRebelProject();
        IContainer newLocation = this.getNewXmlDirectoryPath();
        log.info("User changed the conf directory: '{}'", (Object)newLocation);
        for (String fileName : Arrays.asList("rebel.xml", "rebel-remote.xml")) {
            IFile oldFile = this.getProjectConfigFile(project.getProject(), fileName);
            if (oldFile == null || !oldFile.exists()) continue;
            IFile newFile = newLocation.getFile(Path.fromPortableString((String)fileName));
            this.moveFile(oldFile, newFile);
        }
    }

    private void moveFile(IFile oldFile, IFile newFile) {
        if (oldFile.equals((Object)newFile)) {
            log.debug("Not moving file to itself: {}", (Object)oldFile);
            return;
        }
        try {
            oldFile.move(newFile.getFullPath(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            log.warn("Unable to move conf file: {}", (Object)oldFile, (Object)e);
        }
    }

    private IFile getProjectConfigFile(IProject project, String fileName) {
        IFile oldFile = null;
        if ("rebel.xml".equals(fileName)) {
            oldFile = ProjectHelper.getRebelXml(project);
        } else if ("rebel-remote.xml".equals(fileName)) {
            oldFile = ProjectHelper.getRebelRemoteXml(project);
        }
        return oldFile;
    }

    private IContainer getNewXmlDirectoryPath() {
        if (!this.customXmlDirectoryEnabled.getSelection()) {
            return this.getDefaultXmlDirectory();
        }
        return this.getCustomDirectoryPath();
    }

    private void saveProperties() {
        JRebelProject project = this.getJRebelProject();
        project.useRelativePaths().set(project.getProject(), this.useRelativePaths.getSelection());
        boolean customXmlDirectoryEnabledSelection = this.customXmlDirectoryEnabled.getSelection();
        project.hasCustomXmlDirectory().set(project.getProject(), customXmlDirectoryEnabledSelection);
        if (customXmlDirectoryEnabledSelection) {
            project.customXmlDirectoryPath().set(project.getProject(), this.customDirectoryPath.getText());
        }
        EclipseIdeProject module = this.getIdeModule();
        boolean newIdeGenerationSelection = this.ideGenerationButton.getSelection();
        boolean revertedToIdeGeneration = !module.isIdeRebelXmlGenerationType() && newIdeGenerationSelection;
        module.setRebelXmlGenerationType(newIdeGenerationSelection);
        if (revertedToIdeGeneration) {
            this.setNoAutoConvert();
        }
    }

    private void setNoAutoConvert() {
        RebelXmlGenerationSource.setNoAutoConvert(this.getIdeModule());
    }

    private EclipseIdeProject getIdeModule() {
        return new EclipseIdeProject(this.getProject());
    }
}

