/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.properties;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.zeroturnaround.common.util.IdeStringUtils;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.nature.IRebelRemotingProvider;
import org.zeroturnaround.eclipse.preferences.JRebelConfigCenterProxy;
import org.zeroturnaround.eclipse.properties.AbstractJRebelPropertiesPage;
import org.zeroturnaround.eclipse.properties.ActiveRemoteServersList;
import org.zeroturnaround.eclipse.properties.ExplicitRemoteServersSelectionPanel;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.ui.swt.BoldLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class JRebelRemoteServerPropertiesPage
extends AbstractJRebelPropertiesPage {
    private static final int SHELL_MIN_WIDTH = 700;
    public static final String PAGE_ID = "org.zeroturnaround.eclipse.properties.jrebelRemoteServerPropertiesPage";
    public static final String COMMAND_SELECT_EXPLICIT_SERVER = "SelectExplicitServer";
    private static final Log log = Log.getInstance(JRebelRemoteServerPropertiesPage.class);
    private BaseRemoteModule remotingClientProject;
    IRebelRemotingProvider remotingProvider = Hooks.getHookOpt(IRebelRemotingProvider.class, "org.zeroturnaround.eclipse.remotingProvider");
    private Button deleteFilesOnRemoteServer;
    private ExplicitRemoteServersSelectionPanel explicitRemoteServersSelectionPanel;
    private List<RemoteServerSelection> selections = new ArrayList<RemoteServerSelection>();
    private Composite stackedBottomPanel;
    private Label redeployForChangesLabel;

    public void applyData(Object data) {
        if (data instanceof String && COMMAND_SELECT_EXPLICIT_SERVER.equals(data)) {
            for (RemoteServerSelection selection : this.selections) {
                selection.radio.setSelection(selection.selection.equals((Object)RemoteServerConfigurations.ServerSelection.EXPLICIT_INSTANCE));
            }
            this.onRadioChange();
        }
    }

    protected Control createContents(Composite outerParent) {
        Composite wrapper = new Composite(outerParent, 0);
        wrapper.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        wrapper.setLayout((Layout)new GridLayout(1, false));
        Composite parent = new Composite(wrapper, 0);
        parent.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        parent.setLayout((Layout)new GridLayout(2, false));
        this.stackedBottomPanel = new Composite(wrapper, 0);
        this.stackedBottomPanel.setLayout((Layout)new ResizeableStackLayout(50));
        this.stackedBottomPanel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createRadios(parent, this.stackedBottomPanel);
        IdeRemoting.getInstance().getConfigurations().reloadGlobalStorageAsync();
        this.onRadioChange();
        Point shellSize = this.getShell().getSize();
        shellSize = new Point(Math.max(shellSize.x, 700), shellSize.y);
        this.getShell().setSize(shellSize);
        return parent;
    }

    protected void applyDialogFont(Composite composite) {
        super.applyDialogFont(composite);
        try {
            Button defaultsButton = this.getDefaultsButton();
            if (defaultsButton != null) {
                defaultsButton.setVisible(false);
            }
        }
        catch (Throwable throwable) {}
    }

    private void createRadios(Composite parent, Composite bottomPanel) {
        RemoteServerSelection selection = new RemoteServerSelection();
        selection.radio = this.createRadio(parent, "Off");
        selection.selection = RemoteServerConfigurations.ServerSelection.OFF;
        selection.bottomPanel = this.createEmptyPanel(bottomPanel);
        this.selections.add(selection);
        new Label(parent, 0);
        selection = new RemoteServerSelection();
        selection.radio = this.createRadio(parent, this.getWorkspaceRadioTitle());
        selection.selection = RemoteServerConfigurations.ServerSelection.INSTANCE;
        selection.bottomPanel = this.createWorkspaceServersListPanel(bottomPanel);
        RemoteServerConfigurations.ChangeListener redraw = () -> EclipseUtil.runInUiThread(() -> {
            remoteServerSelection.bottomPanel.dispose();
            remoteServerSelection.bottomPanel = this.createWorkspaceServersListPanel(bottomPanel);
            this.onRadioChange();
        });
        IdeRemoting.getInstance().getConfigurations().addListener(redraw);
        bottomPanel.addDisposeListener(e -> IdeRemoting.getInstance().getConfigurations().removeListener(redraw));
        this.selections.add(selection);
        this.createWorkspaceServerLink(parent);
        selection = new RemoteServerSelection();
        selection.radio = this.createRadio(parent, "Select specific workspace servers for this project");
        selection.selection = RemoteServerConfigurations.ServerSelection.EXPLICIT_INSTANCE;
        selection.bottomPanel = this.createExplicitWorkspaceServersGridPanel(bottomPanel);
        redraw = () -> EclipseUtil.runInUiThread(() -> {
            remoteServerSelection.bottomPanel.dispose();
            remoteServerSelection.bottomPanel = this.createExplicitWorkspaceServersGridPanel(bottomPanel);
            this.onRadioChange();
        });
        IdeRemoting.getInstance().getConfigurations().addListener(redraw);
        bottomPanel.addDisposeListener(e -> IdeRemoting.getInstance().getConfigurations().removeListener(redraw));
        this.selections.add(selection);
        Composite redeployLabelWrapper = new Composite(parent, 0);
        redeployLabelWrapper.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout redeployWrapperLayout = new GridLayout(1, false);
        redeployWrapperLayout.marginHeight = 10;
        redeployLabelWrapper.setLayout((Layout)redeployWrapperLayout);
        this.redeployForChangesLabel = new Label(redeployLabelWrapper, 0);
        this.redeployForChangesLabel.setText("This will enable remote server support. Redeploy project to apply configuration.");
        this.redeployForChangesLabel.setForeground(Display.getCurrent().getSystemColor(9));
        this.redeployForChangesLabel.setVisible(false);
        RemoteServerConfigurations.ServerSelection serverSelection = this.getSavedConfigSelection();
        this.deleteFilesOnRemoteServer = this.createCheckbox(parent, "When a file is not found in IDE workspace, remove it from remote deployment", "JRebel finds files from IDE workspace from folders mapped in rebel.xml", this.remotingClientProject.getDeleteFilesOnSync());
        this.deleteFilesOnRemoteServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelRemoteServerPropertiesPage.this.onDeleteFilesChange();
            }
        });
        this.deleteFilesOnRemoteServer.setEnabled(!serverSelection.equals((Object)RemoteServerConfigurations.ServerSelection.OFF));
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    JRebelRemoteServerPropertiesPage.this.onRadioChange();
                }
            }
        };
        for (RemoteServerSelection selection2 : this.selections) {
            selection2.radio.setSelection(selection2.selection.equals((Object)serverSelection));
            selection2.radio.addSelectionListener((SelectionListener)radioListener);
        }
    }

    private RemoteServerConfigurations.ServerSelection getSavedConfigSelection() {
        return IdeRemoting.getInstance().getConfigurations().getServerSelection(this.getIdeModule());
    }

    protected void onDeleteFilesChange() {
        this.remotingClientProject.setDeleteFilesOnSync(this.deleteFilesOnRemoteServer.getSelection());
    }

    private IdeModule getIdeModule() {
        return this.getRemotingClientProject().getIdeModule();
    }

    private void createWorkspaceServerLink(Composite parent) {
        RemoteServerConfigurations configuration = IdeRemoting.getInstance().getConfigurations();
        if (configuration.getInstanceServers().isEmpty()) {
            this.buildLink(parent, "Add server now", true);
        } else if (configuration.getSyncEnabledInstanceServers().isEmpty()) {
            this.buildLink(parent, "Select servers now", false);
        } else {
            new Label(parent, 0);
        }
    }

    public Link buildLink(Composite container, String text, final boolean isAdding) {
        Link link = new Link(container, 0);
        link.setText("<A>" + text + "</A>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (isAdding) {
                    JRebelRemoteServerPropertiesPage.this.onAddNewServer();
                } else {
                    JRebelRemoteServerPropertiesPage.this.onSelectServer();
                }
            }
        });
        return link;
    }

    private void onAddNewServer() {
        this.getShell().close();
        JRebelConfigCenterProxy.openConfigCenterRemoteServersPage(true);
    }

    private void onSelectServer() {
        this.getShell().close();
        JRebelConfigCenterProxy.openConfigCenterRemoteServersPage(false);
    }

    private Button createRadio(Composite parent, String text) {
        Button radio = new Button(parent, 16);
        radio.setText(text);
        return radio;
    }

    private Button createCheckbox(Composite parent, String labelText, String tooltip, boolean initialValue) {
        Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        button.setText(labelText);
        button.setSelection(initialValue);
        button.setToolTipText(tooltip);
        return button;
    }

    private Composite createEmptyPanel(Composite bottomPanel) {
        Composite parent = new Composite(bottomPanel, 0);
        parent.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        return parent;
    }

    private Composite createExplicitWorkspaceServersGridPanel(Composite bottomPanel) {
        Composite parent = new Composite(bottomPanel, 0);
        parent.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        parent.setLayout((Layout)new GridLayout(1, false));
        new BoldLabel(parent, "Select specific remote servers for this project");
        this.explicitRemoteServersSelectionPanel = new ExplicitRemoteServersSelectionPanel(parent, this.getRemotingClientProject());
        return parent;
    }

    private Composite createWorkspaceServersListPanel(Composite bottomPanel) {
        Composite parent = new Composite(bottomPanel, 0);
        parent.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        parent.setLayout((Layout)new GridLayout(1, false));
        new BoldLabel(parent, "This project will be synchronized to all active workspace servers");
        new Label(parent, 0);
        if (IdeRemoting.getInstance().getConfigurations().getSyncEnabledInstanceServers().isEmpty()) {
            String message = "You have no active JRebel remote servers. Configure and activate servers via\nHelp > JRebel > Configuration > Remote servers.";
            Label label = new Label(parent, 0);
            label.setText(message);
            SWTUtil.setFontStyle((Control)label, 2);
        } else {
            new ActiveRemoteServersList(parent);
        }
        return parent;
    }

    private String getWorkspaceRadioTitle() {
        return String.format("Use all active workspace servers (%s)", this.getActiveServersDescription());
    }

    private String getActiveServersDescription() {
        List servers = IdeRemoting.getInstance().getConfigurations().getSyncEnabledInstanceServers();
        if (servers.isEmpty()) {
            return this.getNoServersDescription();
        }
        if (servers.size() <= 2) {
            return this.joinServerNames(servers);
        }
        return String.format("%d selected", servers.size());
    }

    private String getNoServersDescription() {
        RemoteServerConfigurations configuration = IdeRemoting.getInstance().getConfigurations();
        if (configuration.getInstanceServers().isEmpty()) {
            return "no servers configured";
        }
        return "no active remote servers";
    }

    private String joinServerNames(List<RemoteServerConfiguration> servers) {
        ArrayList<String> list = new ArrayList<String>(servers.size());
        for (RemoteServerConfiguration s : servers) {
            list.add(s.getNameOrUrl());
        }
        String names = StringUtils.join(list, (String)", ");
        return IdeStringUtils.ellipsify((String)names);
    }

    private BaseRemoteModule getRemotingClientProject() {
        if (this.remotingClientProject == null) {
            this.remotingClientProject = this.remotingProvider.getRemotingClientProject(this.getProject());
        }
        return this.remotingClientProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performOk() {
        try {
            RemoteServerConfigurations.ServerSelection selectedRadioValue = this.getSelectedRadioValue();
            if (selectedRadioValue.equals((Object)RemoteServerConfigurations.ServerSelection.EXPLICIT_INSTANCE)) {
                List<RemoteServerConfiguration> selectedServers = this.explicitRemoteServersSelectionPanel.getSelectedServers();
                if (selectedServers.isEmpty()) {
                    this.explicitRemoteServersSelectionPanel.showNoServersSelectedWarning(true);
                    return false;
                }
                IdeRemoting.getInstance().getConfigurations().setExplicitInstanceServers(this.getIdeModule(), selectedServers);
            }
            this.remotingProvider.updateRemotingEnablement(this.getProject(), selectedRadioValue, null);
            return super.performOk();
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    private RemoteServerConfigurations.ServerSelection getSelectedRadioValue() {
        for (RemoteServerSelection selection : this.selections) {
            if (!selection.radio.getSelection()) continue;
            return selection.selection;
        }
        log.error("Unexpected radio button selection", (Throwable)new IllegalStateException());
        return RemoteServerConfigurations.ServerSelection.OFF;
    }

    private void onRadioChange() {
        log.debug("onRadioChange() " + this.getSelectedRadioValue());
        this.explicitRemoteServersSelectionPanel.showNoServersSelectedWarning(false);
        boolean offButtonSelected = this.getSelectedRadioValue().equals((Object)RemoteServerConfigurations.ServerSelection.OFF);
        this.redeployForChangesLabel.setVisible(!offButtonSelected && RemoteServerConfigurations.ServerSelection.OFF.equals((Object)this.getSavedConfigSelection()));
        this.deleteFilesOnRemoteServer.setEnabled(!offButtonSelected);
        Composite top = null;
        for (RemoteServerSelection selection : this.selections) {
            if (!selection.radio.getSelection()) continue;
            ((StackLayout)this.stackedBottomPanel.getLayout()).topControl = selection.bottomPanel;
            top = selection.bottomPanel;
            break;
        }
        this.resizeDialogPageScrolledComposite(top);
    }

    public boolean okToLeave() {
        this.explicitRemoteServersSelectionPanel.showNoServersSelectedWarning(false);
        return super.okToLeave();
    }

    private void resizeDialogPageScrolledComposite(Composite childComposite) {
        Composite c = childComposite;
        while (c != null && !(c instanceof ScrolledComposite)) {
            c = c.getParent();
        }
        if (c == null) {
            log.warn("Couldn't find ScrolledComposite{}", (Object)(childComposite == null ? ", because top was null" : ""));
            return;
        }
        this.getControl().setSize(this.computeSize());
        ScrolledComposite sc = (ScrolledComposite)c;
        sc.setMinSize(this.getControl().getSize());
        c.getShell().layout(true, true);
    }

    public Point computeSize() {
        return this.getControl().computeSize(-1, -1);
    }

    private static class RemoteServerSelection {
        Button radio;
        RemoteServerConfigurations.ServerSelection selection;
        Composite bottomPanel;

        private RemoteServerSelection() {
        }
    }

    private static class ResizeableStackLayout
    extends StackLayout {
        private final int minimumHeight;

        private ResizeableStackLayout(int minimumHeight) {
            this.minimumHeight = minimumHeight;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            int maxWidth = 0;
            int maxHeight = this.minimumHeight;
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(wHint, hHint, flushCache);
                maxWidth = Math.max(size.x, maxWidth);
                if (children[i] == this.topControl) {
                    maxHeight = Math.max(size.y, maxHeight);
                }
                ++i;
            }
            int width = maxWidth + 2 * this.marginWidth;
            int height = maxHeight + 2 * this.marginHeight;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
    }
}

