/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.proxy;

import com.zeroturnaround.http.ProxyProvider;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.http.HttpHost;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.jrebel.client.logger.Log;

public class EclipseProxyProvider
implements ProxyProvider {
    private static final EclipseProxyProvider instance = new EclipseProxyProvider();
    private static final Log log = Log.getInstance(EclipseProxyProvider.class);
    private IProxyService proxyService;

    private EclipseProxyProvider() {
    }

    public static EclipseProxyProvider getInstance() {
        return instance;
    }

    public HttpHost getProxyFor(URI target) {
        log.debug("getProxyFor {}", (Object)target);
        if (target == null) {
            return null;
        }
        try {
            IProxyData proxyData;
            IProxyData[] proxyDatas = this.getProxyService().select(target);
            if (proxyDatas.length == 0 && "https".equals(target.getScheme())) {
                URI httpUri = new URI("http", target.getRawSchemeSpecificPart(), null);
                proxyDatas = this.proxyService.select(httpUri);
            }
            if ((proxyData = this.selectOne(target, proxyDatas)) != null) {
                log.debug("Proxy settings [type: {}, host: {}:{}, user: {}, reqAuth: {}] for {}", new Object[]{proxyData.getType(), proxyData.getHost(), proxyData.getPort(), proxyData.getUserId(), proxyData.isRequiresAuthentication(), target});
                return new HttpHost(proxyData.getHost(), proxyData.getPort());
            }
            log.debug("No proxy found for {}", (Object)target);
            return null;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private IProxyData selectOne(URI target, IProxyData[] proxyDatas) {
        if (proxyDatas == null || proxyDatas.length == 0) {
            return null;
        }
        boolean isHttps = "https".equals(target.getScheme());
        IProxyData[] iProxyDataArray = proxyDatas;
        int n = proxyDatas.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            if (!isHttps && "HTTP".equals(proxyData.getType())) {
                return proxyData;
            }
            if (isHttps && "HTTPS".equals(proxyData.getType())) {
                return proxyData;
            }
            ++n2;
        }
        return proxyDatas[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProxyService getProxyService() {
        EclipseProxyProvider eclipseProxyProvider = this;
        synchronized (eclipseProxyProvider) {
            if (this.proxyService == null) {
                this.proxyService = EclipseProxyProvider.loadProxyService();
            }
        }
        return this.proxyService;
    }

    private static IProxyService loadProxyService() {
        ServiceReference serviceReference = EclipseProxyProvider.getBundleContext().getServiceReference(IProxyService.class.getName());
        IProxyService service = (IProxyService)EclipseProxyProvider.getBundleContext().getService(serviceReference);
        return service;
    }

    private static BundleContext getBundleContext() {
        return RebelPlugin.getDefault().getBundle().getBundleContext();
    }

    public PasswordAuthentication getAuthenticationFor(HttpHost host) {
        log.debug("Eclipse getAuthenticationFor {}:{}", (Object)host);
        for (IProxyData p : this.getAllProxies()) {
            if (!p.isRequiresAuthentication() || !host.getHostName().equals(p.getHost()) || host.getPort() != p.getPort()) continue;
            String pwd = p.getPassword();
            return new PasswordAuthentication(p.getUserId(), pwd != null ? pwd.toCharArray() : new char[]{});
        }
        return this.getPasswordFromUser(host);
    }

    private PasswordAuthentication getPasswordFromUser(HttpHost host) {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)EclipseProxyProvider.getBundleContext(), (String)IProvisioningAgent.SERVICE_NAME);
        UIServices adminUIService = (UIServices)agent.getService(UIServices.SERVICE_NAME);
        if (adminUIService == null) {
            return null;
        }
        log.info("Eclipse asking client in UI for proxy authentication details");
        UIServices.AuthenticationInfo loginDetails = adminUIService.getUsernamePassword(host.getHostName());
        if (loginDetails == null) {
            return null;
        }
        PasswordAuthentication result = new PasswordAuthentication(loginDetails.getUserName(), loginDetails.getPassword().toCharArray());
        log.debug("Eclipse caching and returning authentication details {}:{}", (Object)result.getUserName(), (Object)(result.getPassword() != null ? 1 : 0));
        return result;
    }

    private List<IProxyData> getAllProxies() {
        IProxyService proxyService = this.getProxyService();
        ArrayList<IProxyData> proxies = new ArrayList<IProxyData>();
        proxies.addAll(Arrays.asList(proxyService.getProxyData()));
        if (proxyService instanceof ProxyManager) {
            IProxyData[] data = ((ProxyManager)proxyService).getNativeProxyData();
            proxies.addAll(Arrays.asList(data));
        }
        return proxies;
    }
}

