/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.jrebel.client.logger.Log;

public class FadeUtil {
    private static final Log log = Log.getInstance(FadeUtil.class);

    public static void fadeIn(final Shell shell, final int alphaStep, final int finalAlpha, final int fadeTick, final Runnable whenDone) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int cur = shell.getAlpha();
                    if ((cur += alphaStep) >= finalAlpha) {
                        shell.setAlpha(finalAlpha);
                        whenDone.run();
                        return;
                    }
                    shell.setAlpha(cur);
                    Display.getDefault().timerExec(fadeTick, (Runnable)this);
                }
                catch (Exception err) {
                    log.error((Throwable)err);
                }
            }
        };
        Display.getDefault().timerExec(fadeTick, run);
    }

    public static void startTimer(final Shell shell, int displayTime, final Runnable whenDone) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    whenDone.run();
                }
                catch (Exception err) {
                    log.error((Throwable)err);
                }
            }
        };
        Display.getDefault().timerExec(displayTime, run);
    }

    private static boolean isMouseOver(Shell shell) {
        return shell.getBounds().contains(shell.getDisplay().getCursorLocation());
    }

    public static void startTimerWithMouseOverCheck(final Shell shell, final int displayTime, final Runnable whenDone) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    if (FadeUtil.isMouseOver(shell)) {
                        Display.getDefault().timerExec(displayTime, (Runnable)this);
                    } else {
                        whenDone.run();
                    }
                }
                catch (Exception err) {
                    log.error((Throwable)err);
                }
            }
        };
        Display.getDefault().timerExec(displayTime, run);
    }

    public static void fadeOut(final Shell shell, final int alphaStep, final int finalAlpha, final int fadeTick, final Runnable whenDone) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int cur = shell.getAlpha();
                    if ((cur -= alphaStep) <= finalAlpha) {
                        shell.setAlpha(finalAlpha);
                        whenDone.run();
                        return;
                    }
                    shell.setAlpha(cur);
                    Display.getDefault().timerExec(fadeTick, (Runnable)this);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        };
        Display.getDefault().timerExec(fadeTick, run);
    }
}

